<?php

namespace App\Controllers;

use CodeIgniter\RESTful\ResourceController;

class TenantApiController extends ResourceController
{
    protected $tenantDB;

    public function initController(\CodeIgniter\HTTP\RequestInterface $request, 
                                    \CodeIgniter\HTTP\ResponseInterface $response, 
                                    \Psr\Log\LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        // Get society_id from GET or POST or headers
        $societyId = $this->request->getGet('society_id') 
                    ?? $this->request->getPost('society_id') 
                    ?? $this->request->getHeaderLine('society_id');

        $this->db = \Config\Database::connect();
        if ($societyId) {
            $society = $this->db
                ->table('tbl_society')
                ->where('society_id', $societyId)
                ->get()
                ->getRow();

            if ($society) {
                $tenantConfig = [
                    'DSN'      => '',
                    'hostname' => $society->db_host,
                    'username' => $society->db_user,
                    'password' => $society->db_pass,
                    'database' => $society->db_name,
                    'DBDriver' => 'MySQLi',
                    'DBPrefix' => '',
                    'pConnect' => false,
                    'DBDebug'  => (ENVIRONMENT !== 'production'),
                    'charset'  => 'utf8',
                    'DBCollat' => 'utf8_general_ci',
                ];

            $this->db = \Config\Database::connect($tenantConfig, false);  
            } 
        } 
    }
}
