<?php
$assets = base_url() . 'assets/';
$waterMeterReadingData = !empty($water_meter_reading_data) && is_array($water_meter_reading_data) ? $water_meter_reading_data : array();

 ?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title><?= $name; ?></title>
		<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
			  type="text/css">
		<link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
		<link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">
	</head>
	<body style='font-family:chelvetica;font-size: 9px'>

	<div class="card">
		<div class="card-body">
			<div class="table-responsive text-nowrap">
				<table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
					<tr>
						<td class="text-bold text-center" colspan="5" style="font-size:15px"><?= lang("WaterMeterReading.water_meter_readings"); ?></td>
						<td colspan="2" class="text-bold text-center"><?php if (isset($society_data['society_name']) && $society_data['society_name'] != '') { echo $society_data['society_name']; } ?></td>
					</tr>
					<tr>
						<td class="text-bold text-center" ><?= lang("CommonMessage.common_sr_no"); ?></td>
						<td class="text-bold text-center" ><?= lang("WaterMeterReading.water_tank"); ?></td>
						<td class="text-bold text-center" ><?= lang("WaterMeterReading.reading_date_time"); ?></td>
						<td class="text-bold text-center" ><?= lang("WaterMeterReading.source"); ?></td>
						<td class="text-bold text-center" ><?= lang("WaterMeterReading.availability_volume"); ?></td>
						<td class="text-bold text-center" ><?= lang("WaterMeterReading.supply_volume"); ?></td>
						<td class="text-bold text-center" ><?= lang("WaterMeterReading.description"); ?></td>
					</tr>

                    <?php
                    if (is_array($waterMeterReadingData) && !empty($waterMeterReadingData)) {
                    foreach ($waterMeterReadingData as $wmrKey => $waterMeterReadingValueElement) {
                    ?>
                        <tr>
                            <td class="text-center">
                                <?= ++$wmrKey; ?>
                            </td>
                            <td class="text-center">
								<?= isset($waterMeterReadingValueElement['water_tank_name']) ? $waterMeterReadingValueElement['water_tank_name'] : ''; ?>
                            </td>
							<td class="text-center">
							   <?= (isset($waterMeterReadingValueElement['reading_date_time']) && isValidDate($waterMeterReadingValueElement['reading_date_time'])) ? siteDateFormat($waterMeterReadingValueElement['reading_date_time'],true) : ''; ?>
							</td>
							<td class="text-center">
							   <?= isset($waterMeterReadingValueElement['source']) ? underscoreToUcWord($waterMeterReadingValueElement['source']) : ''; ?>
							</td>
                            <td class="text-center">
                                <?= (isset($waterMeterReadingValueElement['availability_volume']) && ($waterMeterReadingValueElement['availability_volume'] != '')) ? roundNumber($waterMeterReadingValueElement['availability_volume']) : '';  ?>
                            </td>
                            <td class="text-center">
                                <?= (isset($waterMeterReadingValueElement['availability_volume']) && ($waterMeterReadingValueElement['supply_volume'] != '')) ? roundNumber($waterMeterReadingValueElement['supply_volume']) : '';  ?>
                            </td>

                            <td class="text-center">
                                <?= isset($waterMeterReadingValueElement['remarks']) ? $waterMeterReadingValueElement['remarks'] : ''; ?>
                            </td>

                        </tr>

                        <?php
                    }
                    } else {
                        echo "<tr><td colspan='5' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
                    }  ?>
				</table>
			</div>
		</div>
	</div>
	</body>
</html>
