<?php
// Example: generate with mPDF
// $mpdf = new \Mpdf\Mpdf(['mode' => 'utf-8', 'format' => 'A4', 'margin_bottom' => 40]);
// $html = $this->load->view('voucher_view', $data, true);
// $mpdf->WriteHTML($html);
// $mpdf->Output();

$assets = base_url() . 'assets/';
$totalAmount = 0;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $name; ?></title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
        type="text/css">

    <link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
    <link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

    <style>
        /* Ensure body leaves space for footer */
        body {
            font-family: helvetica;
            font-size: 9px;
            margin: 0 10px 80px 10px;
        }

        /* Footer signature styles: no table border, centered lines */
        .footer-signature {
            width: 100%;
            border-collapse: collapse;
            border: 0;
            font-size: 10px;
        }

        .footer-signature td {
            border: 0;
            padding-top: 8px;
            vertical-align: bottom;
            text-align: center;
        }

        .signature-line {
            display: block;
            margin-top: 22px;
            border-top: 1px solid #000;
            width: 80%;
            margin-left: auto;
            margin-right: auto;
            height: 1px;
        }
    </style>

    <style>
		.pdf-footer-table { width:100%; border-collapse:collapse; border:0; font-size:10px; }
		.pdf-footer-table td { border:0; padding:6px 8px; vertical-align:bottom; text-align:center; }
		.signature-cell { padding-top:4px; vertical-align:bottom; }
		.signature-line { display:block; margin:14px auto 4px; border-top:1px solid #000; width:80%; height:1px; }
		.footer-meta { font-size:9px; text-align:center; padding-top:4px; }
	</style>
</head>

<body>
    <h3 style="color: red;text-align: center;"><?= lang('Voucher.voucher_details'); ?></h3>

    <table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
        <tr>
            <td colspan="4" rowspan="2">
                <center><strong>
                        <?php
                        if (isset($society_data['society_name']) && $society_data['society_name'] != '') {
                            echo $society_data['society_name'];
                        } ?> </strong></center>
            </td>
            <td colspan="4">
                <center><strong>Voucher</strong></center>
            </td>
        </tr>
        <tr>
            <td>
                <center><strong>No.</strong></center>
            </td>
            <td>
                <center><?= $voucher_data['reference_no'] ?></center>
            </td>
            <td>
                <center><strong>Date</strong></center>
            </td>
            <td>
                <center><?= isset($voucher_data['date']) && isValidDate($voucher_data['date']) ? siteDateFormat($voucher_data['date']) : "-"  ?></center>
            </td>
        </tr>
        <tr>
            <td colspan="3">
                <center><strong>Paid To</strong></center>
            </td>
            <td colspan="5"></td>
        </tr>
        <tr>
            <td colspan="3">
                <center><strong>Account</strong></center>
            </td>
            <td colspan="5"></td>
        </tr>
        <tr>
            <td colspan="5">
                <center><strong>Particulars</strong></center>
            </td>
            <td colspan="3">
                <center><strong>Amount</strong></center>
            </td>
        </tr>
        <?php if (isset($voucher_items_data) && !empty($voucher_items_data)) {
            foreach ($voucher_items_data as $item) {
                $totalAmount += $item['amount'];
                ?>
                <tr>
                    <td colspan="5">
                        <center><?= $item['item'] ?></center>
                    </td>
                    <td colspan="3">
                        <center><?= $item['amount'] ?></center>
                    </td>
                </tr>
            <?php }
        } ?>
        <tr>
            <td colspan="5" style="text-align: right;"><strong>Total</strong></td>
            <td colspan="3">
                <center><?= $totalAmount; ?></center>
            </td>
        </tr>
        <tr>
            <td colspan="3">
                <center><strong>Rupees in words</strong></center>
            </td>
            <td colspan="5">
                <center><?= getIndianCurrency($totalAmount); ?></center>
            </td>
        </tr>
    </table>

</body>

</html>