<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$voucherView = isset($voucher_data['view']) ? $voucher_data['view'] : 0;
$type = isset($module_type) ? $module_type : 'voucher';
if ($type == 'voucher') {
	$lang = 'Voucher';
} else {
	$lang = 'Receipt';
}
?>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= lang($lang.'.voucher_detail'); ?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id' => 'form_voucher',
                );
                echo form_open_multipart('', $form_id);
                $voucherId = (isset($voucher_data['voucher_id']) && ($voucher_data['voucher_id'] != '')) ? $voucher_data['voucher_id'] : '';
                ?>
                <input type="hidden" id="voucher_id" name="voucher_id" value="<?= $voucherId ?>">
                <input type="hidden" id="delete_voucher_unit_id" name="delete_voucher_unit_id" value="">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="col-form-label" for="basic-default-name"><?= lang($lang.'.voucher_type'); ?><span
                                class="text-danger"> *</span></label>
                        <?php
                        $voucherTypes = voucherType();
                        ?>
                        <select data-placeholder="Select  <?= lang($lang.'.voucher_type'); ?>" name="voucher_type"
                            id="voucher_type" class="select2 form-select form-select-lg dt-voucher-type">
                            <?php
                            $selectedVoucherType = isset($voucher_data['voucher_type']) ? $voucher_data['voucher_type'] : "";
                            foreach ($voucherTypes as $vKey => $voucherType) { ?>
                                <option <?= ($selectedVoucherType == $vKey) ? "selected" : ""; ?>
                                    value="<?= $vKey; ?>"> <?= $voucherType; ?> </option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label class="col-form-label" for="basic-default-name"><?= lang($lang.'.transaction_mode'); ?><span
                                class="text-danger"> *</span></label>
                        <?php
                        $transactionModes = transactionMode();
                        ?>
                        <select data-placeholder="Select  <?= lang($lang.'.transaction_mode'); ?>" name="transaction_mode"
                            id="transaction_mode" class="select2 form-select form-select-lg dt-day-type">
                            <?php
                            $selectedTransactionMode = isset($voucher_data['transaction_mode']) ? $voucher_data['transaction_mode'] : "";
                            foreach ($transactionModes as $tKey => $transactionMode) { ?>
                                <option <?= ($selectedTransactionMode == $tKey) ? "selected" : ""; ?>
                                    value="<?= $tKey; ?>"> <?= $transactionMode; ?> </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="col-form-label" for="basic-default-name"><?= lang($lang.'.date'); ?><span class="text-danger"> *</span></label>
                            <input type="text" class="form-control" name="date" id="date" placeholder="Enter <?= lang($lang.'.date'); ?>" value="<?= (isset($voucher_data['date']) && isValidDate($voucher_data['date'])) ? siteDateFormat($voucher_data['date'], true) : ''; ?>" />
                    </div>
                    <div class="col-md-6">
                        <label class="col-form-label" for="basic-default-name"><?= lang($lang.'.reference_no'); ?><span
                                class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="reference_no" id="reference_no" placeholder="Enter <?= lang($lang.'.reference_no'); ?>" value="<?= (isset($voucher_data['reference_no']) && ($voucher_data['reference_no'] != '')) ? $voucher_data['reference_no'] : ''; ?>" />
                    </div>
                </div><br>

            <div class="row mb-3">
                <label class="col-sm-2 col-form-label"
                    for="basic-default-name"><?= lang($lang.'.narration'); ?><span
                        class="text-danger"> *</span></label>
                <div class="col-sm-10">
                    <textarea name="narration" id="narration" placeholder="Enter <?= lang($lang.'.narration'); ?>" rows="3" cols="5" class="form-control"><?= (isset($voucher_data['narration']) && ($voucher_data['narration'] != '')) ? $voucher_data['narration'] : ''; ?></textarea>
                </div>
            </div>

            <hr class="my-4 mx-n4" />
            <h6>2. <?= lang($lang.'.transaction_information'); ?></h6>
            <div class="row g-3">
                <?= isset($voucher_transaction_table) ? $voucher_transaction_table : ""; ?>
            </div>
            <?php if ($dtCIAcl->checkAccess('Voucher|manage')) { ?>
                <button type="button" class="btn btn-xs btn-primary" onclick="addVoucherTransaction()">
                    <i class="ti ti-plus me-1"></i>
                    <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                </button>
            <?php } ?>

            <hr class="my-4 mx-n4" />
            <h6>3. <?= lang($lang.'.item_information'); ?></h6>
            <div class="row g-3">
                <?= isset($voucher_item_table) ? $voucher_item_table : ""; ?>
            </div>
            <?php if ($dtCIAcl->checkAccess('Voucher|manage')) { ?>
                <button type="button" class="btn btn-xs btn-primary" onclick="addVoucherItem()">
                    <i class="ti ti-plus me-1"></i>
                    <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                </button>
            <?php } ?>
            <?php if ($voucherView != 1) { ?>
                <div class="pt-4">
                    <button type="submit" id="submitBtn"
                        class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Voucher/?type='.$type); ?>'"
                        class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
                </div>
            <?php } ?>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>
</div>

<script>
    var editable = <?= $voucherView ?>;
    if (editable == 1) {
        $("#form_voucher :input").prop("disabled", true);
        $(".dt-delete-item-row").removeAttr("onclick");
        $(".dt-delete-item-row").remove();
        $(".dt-delete-unit-row").removeAttr("onclick");
        $(".dt-delete-unit-row").remove();
    }

    function voucherTransaction() {
        addValidation("input", ".dt-transaction-date", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang($lang.'.date'); ?>",
            }
        });

        addValidation("input", ".dt-ref_no", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang($lang.'.ref_no'); ?>",
            }
        });

        addValidation("input", ".dt-bank", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang($lang.'.bank'); ?>",
            }
        });

        addValidation("input", ".dt-branch", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang($lang.'.branch'); ?>",
            }
        });
        
        addValidation("input", ".dt-city", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang($lang.'.city'); ?>",
            }
        });

        addValidation("input", ".dt-transaction_amount", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang($lang.'.amount'); ?>",
            }
        });
        
        addValidation("textarea", ".dt-remarks", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang($lang.'.remarks'); ?>",
            }
        });

    }

    function voucherItems() {
        addValidation("input", ".dt-item", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang($lang.'.item'); ?>",
            }
        });

        addValidation("input", ".dt-amount", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang($lang.'.amount   '); ?>",
            }
        });

    }

    $(document).ready(function() {
        commonAreaDd();
        taxDd();
        numberInit();
        $("#date").flatpickr({
			dateFormat: "d-m-Y",
		});
        $(".dt-transaction-date").flatpickr({
			dateFormat: "d-m-Y",
		});
        switcheryKeyGen("datatable-list-switchery");
        $(".dt-voucher").select2();
        addSerialNumber('voucher_transaction_table');
        addSerialNumber('voucher_item_table');
        
        numberInit();
        // Initialize
        var validator = $("#form_voucher").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function(label) {
                label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function(error, element) {

                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                voucher_type: {
                    required: true
                },
                narration: {
                    required: true
                },
                transaction_mode: {
                    required: true
                },
                date: {
                    required: true,
                },
                reference_no: {
                    required: true,
                },
            },
            messages: {
                voucher_type: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang($lang.'.voucher_name'); ?>"
                },
                narration: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang($lang.'.narration'); ?>"
                },
                transaction_mode: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang($lang.'.transaction_mode'); ?>"
                },
                reference_no: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Voucher.reference_no"); ?>',
                },
                date: {
                    required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Voucher.date"); ?>',
                },
                
            },
            submitHandler: function(e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("Voucher/save?type=".$type); ?>',
                    type: 'post',
                    beforeSubmit: function(formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
                        dtButtonHide('#cancelBtn');
                    },
                    complete: function() {
                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function(resObj, statusText) {
                        if (resObj.success) {
                            toastr.success(resObj.msg, 'Success', {
                                closeButton: true,
                                progressBar: true,
                                positionClass: 'toast-top-right',
                                timeOut: 1000,
                                onHidden: function() {
                                    dtButtonShow('#submitBtn');
                                    dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Voucher/index/?type='.$type); ?>';
                                }
                            });
                        } else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
                            toastr.error(resObj.msg, 'Error', {
                                closeButton: true,
                                positionClass: 'toast-top-right',
                            });
                        }
                    }
                });
            }
        });

        voucherTransaction();
        voucherItems();
    });
</script>

<script>
    const modeMapping = {
        bank_payment: ['cheque', 'neft_rtgs', 'imps_upi', 'credit_debit_card'],
        bank_receipt: ['cheque', 'neft_rtgs', 'imps_upi', 'credit_debit_card'],
        cash_payment: ['cash'],
        cash_receipt: ['cash']
    };

    const allModes = {
        cheque: "Cheque",
        neft_rtgs: "NEFT/RTGS",
        imps_upi: "IMPS/UPI",
        credit_debit_card: "Credit/Debit Card",
        cash: "Cash"
    };

    $(document).ready(function () {
        function updateTransactionModes(selectedVoucherType, selectedTransactionMode = null) {
            const allowedModes = modeMapping[selectedVoucherType] || [];
            const $transactionMode = $('#transaction_mode');

            $transactionMode.empty(); // Clear current options
            allowedModes.forEach(mode => {
                const isSelected = selectedTransactionMode === mode ? 'selected' : '';
                $transactionMode.append(`<option value="${mode}" ${isSelected}>${allModes[mode]}</option>`);
            });

            $transactionMode.trigger('change'); // Refresh select2 if used
        }

        // On change event of voucher_type
        $('#voucher_type').on('change', function () {
            const selectedVoucherType = $(this).val();
            updateTransactionModes(selectedVoucherType);
        });

        // Trigger on page load if value is already selected (edit case)
        const initialVoucherType = $('#voucher_type').val();
        if (initialVoucherType) {
            // updateTransactionModes(initialVoucherType);
            const initialTransactionMode = '<?= isset($voucher_data['transaction_mode']) ? $voucher_data['transaction_mode'] : '' ?>';
            updateTransactionModes(initialVoucherType, initialTransactionMode);
        }
    });
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>