<?php
$html = '';
if (isset($voucher_transaction_data) && !empty($voucher_transaction_data)) {
	foreach ($voucher_transaction_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["voucher_transaction_data"] = $value;
		$html .= view('Admin/Voucher/VoucherTransactionRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="voucher_transaction_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('Voucher.date'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Voucher.ref_no'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Voucher.bank'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Voucher.branch'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Voucher.city'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Voucher.amount'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Voucher.remarks'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($voucher_transaction_data) && !empty($voucher_transaction_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/Voucher/VoucherTransactionRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addVoucherTransaction() {
		var lastIndex = ($("#voucher_transaction_table tbody tr:last").length >= 1) ? $("#voucher_transaction_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Voucher/addVoucherTransactionRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#voucher_transaction_table tbody').append(data);
					addSerialNumber('voucher_transaction_table');
                    voucherTransaction();
					customToolTip();
					$(".dt-transaction-date").flatpickr({
						dateFormat: "d-m-Y",
					});
                    // unitPriceStore();
				}
			}
		});
	}

	var deleteId = [];
	$(document).on('click', '.dt-delete-transaction-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".voucher_transaction_id").val();
		var amenitiesId = $("#amenities_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					deleteId.push(id);
					$("#delete_voucher_transaction_id").val(deleteId);
                    $(trField).remove();
                    addSerialNumber('voucher_transaction_table');
                    if ($('#voucher_transaction_table tbody > tr').length == 0) {
                        addVoucherTransaction();
						updateUnitNames();
                        unitPriceStore();
                    }
                    unitPriceStore();
					// $.ajax({
					// 	type: "POST",
					// 	url: "<?php echo admin_url('Voucher/deleteVoucherUnitRow');?>",
					// 	dataType: "json",
					// 	async:false,
					// 	data: {
                    //         amenities_unit_id: deleteId,
                    //         amenities_id: amenitiesId
					// 	},
					// 	success: function (resObj) {
					// 		if (resObj.success) {
					// 			$(trField).remove();
					// 			addSerialNumber('voucher_transaction_table');
					// 			Swal.fire({
					// 				title: 'Success',
					// 				text: resObj['msg'],
					// 				icon: 'success',
					// 				customClass: {
					// 					confirmButton: 'btn btn-primary waves-effect waves-light'
					// 				},
					// 				buttonsStyling: false
					// 			}).then(function() {
					// 				if ($('#voucher_transaction_table tbody > tr').length == 0) {
                    //                     addVoucherTransaction();
					// 					updateUnitNames();
                    //                     unitPriceStore();
					// 				}
                    //                 unitPriceStore();
					// 			});

					// 		} else {
					// 			Swal.fire({
					// 				title: 'Error!',
					// 				text: resObj['msg'],
					// 				icon: 'error',
					// 				customClass: {
					// 					confirmButton: 'btn btn-primary waves-effect waves-light'
					// 				},
					// 				buttonsStyling: false
					// 			});
                    //             unitPriceStore();
					// 		}
					// 	}
					// });
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('voucher_transaction_table');
			if ($('#voucher_transaction_table tbody > tr').length == 0) {
                addVoucherTransaction();
				updateUnitNames();
			}
            unitPriceStore();
		}
	});
</script>