<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$rowNumber = isset($row_number) ? $row_number : 0;
$voucher_transaction_data = isset($voucher_transaction_data) ? $voucher_transaction_data : array();
$voucherTransactionId = isset($voucher_transaction_data['voucher_transaction_id']) ? $voucher_transaction_data['voucher_transaction_id'] : array();

// Generate a default transaction name based on the row number if not set
$defaultTransactionName = "Transaction-" . ($rowNumber);  // Adding 1 because row number might be 0-indexed
$transactionName = isset($voucher_transaction_data['transaction_name']) ? $voucher_transaction_data['transaction_name'] : $defaultTransactionName;
?>
<tr data-id="tr_<?= $rowNumber; ?>">
	<td scope="row" class="dt-serial_number"></td>
	<td>
		<input type="hidden" id="voucher_transaction_id_<?= $rowNumber; ?>"  name="voucher_transaction_id[<?= $rowNumber; ?>]" class="voucher_transaction_id" value="<?= isset($voucher_transaction_data['voucher_transaction_id']) ? $voucher_transaction_data['voucher_transaction_id'] : ""; ?>">

        <input type="text" name="transaction_date[<?= $rowNumber;?>]" id="transaction_date_<?= $rowNumber;?>" class="form-control dt-transaction-date" placeholder="Enter <?= lang('Voucher.transaction_date'); ?>"  value="<?= (isset($voucher_transaction_data['transaction_date']) && isValidDate($voucher_transaction_data['transaction_date'])) ? siteDateFormat($voucher_transaction_data['transaction_date']) : ''; ?>" />
	</td>

    <td>
        <input type="text" name="ref_no[<?= $rowNumber;?>]" id="ref_no_<?= $rowNumber;?>" class="form-control dt-ref_no" placeholder="Enter <?= lang('Voucher.ref_no'); ?>"  value="<?= isset($voucher_transaction_data['transaction_ref_no']) ? $voucher_transaction_data['transaction_ref_no'] : ""; ?>" />
	</td>

    <td>
        <input type="text" name="bank[<?= $rowNumber;?>]" id="bank_<?= $rowNumber;?>" class="form-control dt-bank" placeholder="Enter <?= lang('Voucher.bank'); ?>"  value="<?= isset($voucher_transaction_data['bank']) ? $voucher_transaction_data['bank'] : ""; ?>" />
	</td>

    <td>
        <input type="text" name="branch[<?= $rowNumber;?>]" id="branch_<?= $rowNumber;?>" class="form-control dt-branch" placeholder="Enter <?= lang('Voucher.branch'); ?>"  value="<?= isset($voucher_transaction_data['branch']) ? $voucher_transaction_data['branch'] : ""; ?>" />
	</td>

    <td>
        <input type="text" name="city[<?= $rowNumber;?>]" id="city_<?= $rowNumber;?>" class="form-control dt-city" placeholder="Enter <?= lang('Voucher.city'); ?>"  value="<?= isset($voucher_transaction_data['city']) ? $voucher_transaction_data['city'] : ""; ?>" />
	</td>
    <td>
        <input type="text" name="transaction_amount[<?= $rowNumber;?>]" id="transaction_amount_<?= $rowNumber;?>" class="form-control dt-transaction_amount" placeholder="Enter <?= lang('Voucher.amount'); ?>"  value="<?= isset($voucher_transaction_data['transaction_amount']) ? $voucher_transaction_data['transaction_amount'] : ""; ?>" />
	</td>
    <td>
        <textarea type="text" name="remarks[<?= $rowNumber;?>]" id="remarks_<?= $rowNumber;?>" class="form-control dt-remarks" placeholder="Enter <?= lang('Voucher.remarks'); ?>"  value="" ><?= isset($voucher_transaction_data['remarks']) ? $voucher_transaction_data['remarks'] : ""; ?></textarea>
	</td>
	
	<td>
        <?php if (!empty($voucherTransactionId)) { ?>
            <?php if ($dtCIAcl->checkAccess('Voucher|deleteItem')) { ?>
                <button type="button"
                        class="rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-transaction-row"
                        data-bs-toggle="tooltip"
                        data-bs-placement="top" title="<?= lang('Voucher.delete_transaction') ?>">
                    <i class="ti ti-trash"></i>
                </button>
            <?php } ?>
        <?php } else { ?>
            <button type="button" class=" rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-transaction-row"
                    data-bs-toggle="tooltip"
                    data-bs-placement="top" title="<?= lang('Voucher.delete_transaction') ?>">
                <i class="ti ti-trash"></i>
            </button>
        <?php } ?>
    </td>

</tr>

