<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$rowNumber = isset($row_number) ? $row_number : 0;
$voucher_items_data = isset($voucher_items_data) ? $voucher_items_data : array();
$voucherItemId = isset($voucher_items_data['voucher_item_id']) ? $voucher_items_data['voucher_item_id'] : array();

// Generate a default item name based on the row number if not set
$defaultItemName = "Item-" . ($rowNumber);  // Adding 1 because row number might be 0-indexed
$itemName = isset($voucher_items_data['item_name']) ? $voucher_items_data['item_name'] : $defaultItemName;
?>
<tr data-id="tr_<?= $rowNumber; ?>">
	<td scope="row" class="dt-serial_number"></td>
	<td>
		<input type="hidden" id="voucher_items_id_<?= $rowNumber; ?>"  name="voucher_items_id[<?= $rowNumber; ?>]" class="voucher_items_id" value="<?= isset($voucher_items_data['voucher_items_id']) ? $voucher_items_data['voucher_items_id'] : ""; ?>">

        <input type="text" name="item[<?= $rowNumber;?>]" id="item_<?= $rowNumber;?>" class="form-control dt-item" placeholder="Enter <?= lang('Voucher.item'); ?>"  value="<?= isset($voucher_items_data['item']) ? $voucher_items_data['item'] : ""; ?>" />
	</td>

    <td>
        <input type="text" name="amount[<?= $rowNumber;?>]" id="amount_<?= $rowNumber;?>" class="form-control dt-amount" placeholder="Enter <?= lang('Voucher.amount'); ?>"  value="<?= isset($voucher_items_data['amount']) ? $voucher_items_data['amount'] : ""; ?>" />
	</td>
	
	<td>
        <?php if (!empty($voucherItemId)) { ?>
            <?php if ($dtCIAcl->checkAccess('Voucher|deleteItem')) { ?>
                <button type="button"
                        class="rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-item-row"
                        data-bs-toggle="tooltip"
                        data-bs-placement="top" title="<?= lang('Voucher.delete_item') ?>">
                    <i class="ti ti-trash"></i>
                </button>
            <?php } ?>
        <?php } else { ?>
            <button type="button" class=" rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-item-row"
                    data-bs-toggle="tooltip"
                    data-bs-placement="top" title="<?= lang('Voucher.delete_item') ?>">
                <i class="ti ti-trash"></i>
            </button>
        <?php } ?>
    </td>

</tr>

