<!-- Add New company Modal -->
<div class="modal fade" id="visitor_company_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-simple modal-add-new-address">
        <div class="modal-content p-3 p-md-5">
            <div class="modal-body">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="text-center mb-4">
                    <h3 class="address-title mb-2"><?= lang('VisitorCompany.visitor_company_form'); ?></h3>
                </div>
                <?php
                $form_id = array(
                    'id' => 'form_visitor_company',
                    'method' => 'post',
                    'class' => 'row g-3',
                    'autocomplete' => 'off'
                );
                echo form_open_multipart('',$form_id);
                ?>
                <input type="hidden" name="visitor_company_id" id="visitor_company_id">

                <div class="col-12">
                    <label class="form-label" for=""><?= lang('VisitorCompany.visitor_company_type'); ?><span class="text-danger"> *</span></label>
                    <?php
                        $visitorCompanyTypes = visitorCompanyType();
                    ?>
                    <select data-placeholder="Select  <?= lang('VisitorCompany.visitor_company_type'); ?>" name="visitor_company_type" id="visitor_company_type"  class="select2 form-select form-select-lg dt-visitor-company-type" data-allow-clear="true">
                        <?php
                        foreach ($visitorCompanyTypes as $visitorCompanyKey => $visitorCompany) { ?>
                            <option value="<?= $visitorCompanyKey; ?>"> <?= $visitorCompany; ?> </option>
                        <?php } ?>
                    </select>
                </div>

                <div class="col-12">
                    <label class="form-label" for=""><?= lang('VisitorCompany.visitor_company_name'); ?><span class="text-danger"> *</span></label>
                    <input
                            type="text"
                            id="visitor_company_name"
                            name="visitor_company_name"
                            class="form-control"
                            placeholder="Enter <?= lang('VisitorCompany.visitor_company_name'); ?>"/>
                </div>

                <div class="col-12">
                    <label class="form-label" for=""><?= lang('VisitorCompany.visitor_company_image'); ?><span class="text-danger"> </span></label>

                    <input type="file" accept="image/*" class="form-control" name="visitor_company_image">
                    <span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span> <br>
                    <span id="image_display">
                    </span>
                </div>
                <div class="col-12">
                    <label class="switch switch-sm">
                        <input type="checkbox" class="switch-input form-add-switchery "  name="is_active" id="is_active"/>
                        <span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
                        <span class="switch-label"><?= lang('CommonMessage.common_active'); ?></span>
                    </label>
                </div>
                <div class="col-12 text-center">
                    <button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button
                            id="cancelBtn"
                            type="reset"
                            class="btn btn-label-secondary"
                            data-bs-dismiss="modal"
                            aria-label="Close">
                        <?= lang('CommonMessage.common_cancel'); ?>
                    </button>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>
<!--/ Add New Address Modal -->
<!--  add,update and delete model code here-->
<script type="text/javascript">
    //var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
    $(document).ready(function () {
        $('.dt-visitor-company-type').select2();
        Select2InitModalPopup();
        //validation
        var validator = $("#form_visitor_company").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                label.addClass('validation-valid-label'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {
                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                visitor_company_name: {
                    required: true
                },
                visitor_company_type: {
                    required: true
                },
            },
            messages: {
                visitor_company_name: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('VisitorCompany.visitor_company_name'); ?>",
                },
                visitor_company_type: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('VisitorCompany.visitor_company_type'); ?>",
                },
            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("VisitorCompany/addEdit");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
                        dtButtonHide('#cancelBtn');
                    },
                    complete: function () {
                        //laddaStop();
                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');                                    
                                    dtButtonShow('#cancelBtn');
                                    $('#visitor_company_modal').modal('hide');
                                    dt_DataTable.ajax.reload(null, false);
                                }
							});
							// setTimeout(function () {
                            //     $('#visitor_company_modal').modal('hide');
							// 	dt_DataTable.ajax.reload(null, false);
							// }, 1000);
						} else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });
    });
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>