<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
    <div class="card-datatable text-nowrap table-responsive">
        <table id="visitor_table" class="table dt-datatable dt-scrollableTable">
            <thead class="border-top">
            <tr>
                <th class="font-weight-bold"><?= lang("Visitor.visitor_id"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.visitor_name"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.visitor_mobile_no"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.visitor_purpose"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.vehicle_type"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.vehicle_no"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.flat_no"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.visitor_company_name"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.no_of_parcel"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.collect_on_gate"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.status"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.start_date"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.end_date"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.no_of_visitor"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.delivery_reference_name"); ?></th>
                <th class="font-weight-bold"><?= lang("Visitor.delivery_reference_mobile"); ?></th>
                <th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
            </tr>
            </thead>
        </table>
    </div>
    <!--	</div>-->
</div>
<script type="text/javascript">
    var dt_DataTable;

    $(document).ready(function () {
        flatDd();
        dt_DataTable = $('#visitor_table').DataTable( {
            dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
                '<"me-5 ms-n2 pe-5"f>' +
                '<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
                '>t' +
                '<"row mx-2"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            processing: true,
            serverSide: true,
            displayLength: 10,
            scrollX: true,
            // language: {
            // 	sLengthMenu: 'Show _MENU_',
            // 	search: '',
            // 	searchPlaceholder: 'Search Visitor'
            // },
            language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search Visitor',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },

            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
                    text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
                    buttons: [
                        {
                            text: '<i class="ti ti-file me-2" ></i>Excel',
                            className: 'dropdown-item dt-excel-export'
                        },
                        // {
                        // 	extend: 'pdf',
                        // 	text: '<i class="ti ti-file-text me-2"></i>Pdf',
                        // 	className: 'dropdown-item',
                        //
                        // }
                    ]
                },
            ],
            "ajax": {
                "url": "<?php echo admin_url('Visitor/getVisitorListing'); ?>",
                "type": "POST",
                "data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
            },
            "order": [[ 0, "desc" ]],
            "columns": [
                {"data": "visitor_id" ,    visible: false,},
                {"data": "visitor_name"},
                {"data": "visitor_mobile_no" },
                {"data": "visitor_purpose",},
                {"data": "vehicle_type"},
                {"data": "vehicle_no"},
                {"data": "flat_no"},
                {"data": "visitor_company_name"},
                {"data": "no_of_parcel"},
                {"data": "collect_on_gate"},
                {"data": "status"},
                {"data": "start_date"},
                {"data": "end_date"},
                {"data": "no_of_visitor"},
                {"data": "delivery_reference_name"},
                {"data": "delivery_reference_mobile"},
                {"data": "updated_at" },
				{"data": "updated_by" },
            ],
            "fnDrawCallback": function (oSettings, json) {
                $('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
                $('.dt-buttons').addClass('d-flex flex-wrap');
                $('.dataTables_filter .form-control').removeClass('form-control-sm');
                $('.dataTables_length .form-select').removeClass('form-select-sm');
                customToolTip();
            }
        });
        dtDataTableSearch();

    });

    $(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});

    $(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #filter_flat_id').val('').trigger('change');
        $("#filter_start_date").val('');
        $("#filter_end_date").val('');
        // $("#filter_otp_validity").val('');
        $("#filter_created_at").val('');
        $("#filter_updated_at").val('');
		dt_DataTable.draw();
	});

    $(document).on('click', '.dt-excel-export', function() {
        $(this).removeClass(".dt-excel-export");
        var dataTableParams = dt_DataTable.ajax.params();
        url = '<?= admin_url('Visitor/excelExportVisitor/') . ""  ?>';
        var recursiveEncoded = $.param(dataTableParams);
        $('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
        $('.dt-export-anchor')[0].click();
    });
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
