<?php
$periodFrom = (isset($visit_data['period_from']) && (isValidDate(['period_from']))) ? YMDToDMY($visit_data['period_from']) : '';
$periodTo = (isset($visit_data['period_upto']) && (isValidDate(['period_upto']))) ? YMDToDMY($visit_data['period_upto']) : '';
$amcId = (isset($visit_data['amc_id']) ) ? $visit_data['amc_id'] : '';
?>
<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#visit_detail" aria-controls="visit_detail" aria-selected="true">
			<?= lang('Visit.visit_detail'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="visit_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="visit_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Visit.society"); ?></td>
						<td><?php
							echo (isset($visit_data['society_name']) && $visit_data['society_name'] != "") ? $visit_data['society_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Visit.visit_date_time"); ?></td>
						<td><?php
							echo (isValidDate($visit_data['visit_date_time']) && $visit_data['visit_date_time'] != "") ? siteDateFormat($visit_data['visit_date_time'],true) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Visit.visit_type"); ?></td>
						<td><?php
							echo (isset($visit_data['visit_type']) && $visit_data['visit_type'] != "") ? underscoreToUcWord($visit_data['visit_type']) : '-';
							?>
						</td>
					</tr>
					<tr>
                        <td><?= lang("Visit.service_provider"); ?></td>
						<td><?php
							echo (isset($visit_data['service_provider']) && $visit_data['service_provider'] != "") ? $visit_data['service_provider'] : '-';
							?>
						</td>
					</tr>
                    <tr>
                        <td><?= lang("Visit.amc"); ?></td>
                        <td><?php
                            echo (isset($visit_data['particular']) && $visit_data['particular'] != "") ? underscoreToUcWord($visit_data['particular']) : '-';

                            if ( $amcId != 0) {
                                echo " (".lang('Visit.amc_period')." = " . $periodFrom . " To " . $periodTo. ")";
                            }

                            ?>
                        </td>
                    </tr>
					<tr>
						<td><?= lang("Visit.remarks"); ?></td>
						<td><?php
							echo (isset($visit_data['remarks']) && $visit_data['remarks'] != "") ? $visit_data['remarks'] : '-';
							?>
						</td>
					</tr>
                    <?php if($visit_data['visit_type'] != 'paid') {?>
					<tr>
						<td><?= lang("Visit.amount"); ?></td>
						<td>-</td>
					</tr>					
                    <?php } else {?>
                        <tr>
						<td><?= lang("Visit.amount"); ?></td>
						<td><?php
							echo (isset($visit_data['amount']) && $visit_data['amount'] != "") ? indianMoneyFormat($visit_data['amount'],2,1) : '-';
							?>
						</td>
					</tr>
                    <?php }?>
                        <tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($visit_data['created_at']) && isValidDate($visit_data['created_at'])) ? siteDateFormat($visit_data['created_at'], TRUE) : '-';
							?></td>
					</>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($visit_data['created_by']) && $visit_data['created_by'] != "") ? $visit_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($visit_data['updated_at']) && isValidDate($visit_data['updated_at'])) ? siteDateFormat($visit_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($visit_data['updated_by']) && $visit_data['updated_by'] != "") ? $visit_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>