<?php
$periodFrom = (isset($visit_data['period_from']) && (isValidDate(['period_from']))) ? YMDToDMY($visit_data['period_from']) : '';
$periodTo = (isset($visit_data['period_upto']) && (isValidDate(['period_upto']))) ? YMDToDMY($visit_data['period_upto']) : '';
$amcId = (isset($visit_data['amc_id']) ) ? $visit_data['amc_id'] : '';
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Visit.visit_form');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_visit',
				);
				echo form_open_multipart('',$form_id);
				$visitId = (isset($visit_data['visit_id']) && ($visit_data['visit_id'] != '')) ? $visit_data['visit_id'] : '';
                $isVisitTypePaid = (isset($visit_data['visit_type']) && ($visit_data['visit_type'] != '')) ? $visit_data['visit_type'] : '';
				?>
				<input type="hidden" id="visit_id" name="visit_id" value="<?= $visitId ?>">
				<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Visit.visit_date_time');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="visit_date_time" id="visit_date_time" placeholder="Enter <?= lang('Visit.visit_date_time');?>" value="<?= (isset($visit_data['visit_date_time']) && isValidDate($visit_data['visit_date_time'])) ? siteDateFormat($visit_data['visit_date_time'],true) : ''; ?>" />
						</div>
				</div>


				<div class="row mb-3">	
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Visit.service_provider');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<select id="vendor_id" name="vendor_id" class="select2 form-select form-select-lg vendorDd" data-allow-clear="true">
							<option value=""></option>
							<?php if(isset($visit_data['vendor_id']) && $visit_data['vendor_id'] != 0){ ?>
								<option value="<?= isset($visit_data['vendor_id']) ? $visit_data['vendor_id'] : '' ?>" selected> <?= isset($visit_data['service_provider']) ? $visit_data['service_provider'] : ''  ?> </option>
							<?php } ?>
						</select>
					</div>
				</div>

                <div class="row mb-3">	
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Visit.amc');?></label>
					<div class="col-sm-10">
						<select id="amc_id" name="amc_id" class="select2 form-select form-select-lg amcDd" data-allow-clear="true" data-placeholder="Select  <?= lang('Visit.amc'); ?>">
							<?php if(isset($visit_data['amc_id']) && $visit_data['amc_id'] != 0){ ?>
								<option value="<?= isset($visit_data['amc_id']) ? $visit_data['amc_id'] : 0 ?>" selected> <?= isset($visit_data['particular']) ? $visit_data['particular'] : ''  ?> </option>
							<?php } ?>
						</select>
                        <div id="dt-amc-period" class="form-text">
                            <?php
                            if($visitId != '' && $amcId != 0){
                                echo lang('Visit.amc_period')." = ".$periodFrom ." To ".$periodTo;
                            }
                            ?>
                        </div>
					</div>
				</div>

                

                <div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Visit.visit_type');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<?php
						$visitTypes = visitType();
						?>
						<select data-placeholder="Select  <?= lang('Visit.visit_type'); ?>" name="visit_type"
								id="visit_type" class="select2 form-select dt-visit-type">
							<option> </option>
							<?php
							$selectedVisitType = isset($visit_data['visit_type']) ? $visit_data['visit_type'] : "";
							foreach ($visitTypes as $visitKey => $visitType) { ?>
								<option <?= ($selectedVisitType == $visitKey) ? "selected" : ""; ?>
									value="<?= $visitKey; ?>"> <?= $visitType; ?> </option>
							<?php } ?>
						</select>
					</div>
				</div>

				<div class="row mb-3" id='amount'>
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Visit.amount');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control numberInit" name="amount" id="amount" placeholder="Enter <?= lang('Visit.amount');?>" value="<?= (isset($visit_data['amount']) && ($visit_data['amount'] != '')) ? $visit_data['amount'] : '';  ?>" />
					</div>
				</div>
                
                <div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Visit.remarks');?></label>
						<div class="col-sm-10">
							<textarea name="remarks"  id="remarks" placeholder="Enter <?= lang('Visit.remarks'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($visit_data['remarks']) && ($visit_data['remarks'] != '')) ? $visit_data['remarks'] : ''; ?></textarea>
						</div>
					
                </div>
                
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
					<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($visit_data['is_active']) || $visit_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
							<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
						</label>
					</div>
				</div>

				<div class="pt-4">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Visit'); ?>'" class="btn btn-label-secondary">Cancel</button>
				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $('#amount').hide();
	$(document).ready(function() {
		vendorDd();
		numberInit();
		switcheryKeyGen("datatable-list-switchery");
		$('.dt-visit-type').select2();
		$("#amc_id").select2();
		// Initialize
        $('#vendor_id').on('change', function(){
            var vendorId = $(this).val();
			console.log(vendorId);
            if(vendorId != ''){
                $("#amc_id").val('').trigger('change');
                $("#dt-amc-period").text('');
                amcDd();
            }
            else{
                $("#amc_id").select2();
            }  
        });

		var validator = $("#form_visit").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				visit_date_time: {
					required: true,
				},
				visit_type: {
					required: true,
				},
				vendor_id: {
					required: true,
				},
				// amc_id: {
				// 	required: true,
				// },
				amount: {
					required: "#amount:visible",
				}
			},
			messages: {
				visit_date_time: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Visit.visit_date_time"); ?>',
				},
				visit_type: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Visit.visit_type"); ?>',
				},
				vendor_id: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Visit.service_provider"); ?>',
				},
				// amc_id: {
				// 	required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Visit.amc_type"); ?>',
				// },
				amount: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Visit.amount"); ?>',
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Visit/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Visit');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Visit');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
        $("#visit_date_time").flatpickr({
			// monthSelectorType: 'static',
    		enableTime: true,
    		dateFormat: "d-m-Y H:i",
			// dateFormat: 'd-m-Y'
		});
	});

    $(document).on('change', '#visit_type', function () {
        // console.log("dsdsdsds");
        // console.log($('#visit_type').val() == "paid");
        if($('#visit_type').val() == 'paid'){
            // $("#amount").removeClass("d-none");
            $("#amount").show();
        }
        else {
            // $("#amount").addClass("d-none");
            $("#amount").hide();
        }
    });

    <?php if(!empty($visitId)){
        if($isVisitTypePaid == 'paid'){ ?>
            // $("#amount").removeClass("d-none");
            $("#amount").show();
        <?php }
    } ?>

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
<div id="view_model_service_item">

</div>