<?php
$html = '';
if (isset($tower_unit_data) && !empty($tower_unit_data)) {
	foreach ($tower_unit_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["tower_unit_data"] = $value;
		$html .= view('Admin/Tower/TowerUnitRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="tower_unit_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th style="width: 1%"><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th style="width: 10%"><?= lang('Tower.unit'); ?><span class="text-danger"> *</span></th>
				<th style="width: 10%"><?= lang('Tower.unit_group'); ?><span class="text-danger"> *</span></th>
				<th style="width: 10%"><?= lang('Tower.number_type'); ?><span class="text-danger"> *</span></th>

				<th class="dt-range-label" style="width: 10%"><?= lang('Tower.range_label'); ?><span class="text-danger"> *</span></th>
				<th class="dt-range-start-from" style="width: 10%"><?= lang('Tower.range_start_from'); ?><span class="text-danger"> *</span></th>
				<th style="width: 15%"><?= lang('Flat.bhk'); ?><span class="text-danger"> *</span></th>
				<th style="width: 15%"><?= lang('Flat.sqr_ft'); ?><span class="text-danger"> *</span></th>
				<th style="width: 15%"><?= lang('Flat.carpet_area'); ?><span class="text-danger"> *</span></th>
				<th style="width: 10%"><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($tower_unit_data) && !empty($tower_unit_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/Tower/TowerUnitRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addTowerUnit() {
		var lastIndex = ($("#tower_unit_table tbody tr:last").length >= 1) ? $("#tower_unit_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Tower/addTowerUnitRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#tower_unit_table tbody').append(data);
					addSerialNumber('tower_unit_table');
					$(".dt-number-type").select2();
					numberInit();
					customToolTip();
				}
			}
		});
		$('.dt-number-type').trigger('change');
		towerUnitValidation();
	}


	$(document).on('click', '.dt-delete-unit-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".tower_unit_id").val();
		var towerId = $("#tower_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('Tower/deleteTowerUnitRow');?>",
						dataType: "json",
						async:false,
						data: {
                            tower_unit_id: deleteId,
                            tower_id: towerId
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('tower_unit_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#tower_unit_table tbody > tr').length == 0) {
                                        addTowerUnit();
									}
								});
							} else {
								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('tower_unit_table');
			if ($('#tower_unit_table tbody > tr').length == 0) {
                addTowerUnit();
			}
		}
	});


</script>
