<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#tower_detail" aria-controls="tower_detail" aria-selected="true">
			<?= lang('Tower.tower_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#tower-unit-information" aria-controls="tower-unit-information" aria-selected="false">
			<?= lang('Tower.tower_unit_information'); ?>
		</button>
	</li>                                 
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="tower_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="tower_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Tower.tower"); ?></td>
						<td><?php
							echo (isset($tower_data['tower_name']) && $tower_data['tower_name'] != "") ? $tower_data['tower_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($tower_data['created_at']) && isValidDate($tower_data['created_at'])) ? siteDateFormat($tower_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($tower_data['created_by']) && $tower_data['created_by'] != "") ? $tower_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($tower_data['updated_at']) && isValidDate($tower_data['updated_at'])) ? siteDateFormat($tower_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($tower_data['updated_by']) && $tower_data['updated_by'] != "") ? $tower_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	
    <div class="tab-pane fade" id="tower-unit-information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="tower_unit_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang("Tower.unit"); ?></th>
						<th><?= lang("Tower.unit_group"); ?></th>
						<th><?= lang("Tower.number_type"); ?></th>
						<th><?= lang("Tower.range_label"); ?></th>
						<th><?= lang("Tower.range_start_from"); ?></th>
						<th><?= lang("Flat.bhk"); ?></th>
						<th><?= lang("Flat.sqr_ft"); ?></th>
						<th><?= lang("Flat.carpet_area"); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($tower_unit_data != '' && array_filter($tower_unit_data)) { ?>
						<?php
						$sr = 1;
						foreach ($tower_unit_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td><?= $value['unit']; ?> </td>
								<td><?= $value['unit_group']; ?> </td>
								<td><?= underscoreToUcWord($value['number_type']); ?> </td>
								<td><?= (isset($value['range_label']) && $value['range_label'] != "") ? $value['range_label'] : "-"; ?> </td>
								<td><?= (isset($value['range_start_from']) && $value['range_start_from'] != "") ? $value['range_start_from'] : "-"; ?> </td>
								<td><?= $value['bhk']; ?> </td>
								<td><?= $value['sqr_ft']; ?> </td>
								<td><?= $value['carpet_area']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="9" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div>
</div>