<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$request    = \Config\Services::request();
?>
<style type="text/css">
    .readonly-dropdown {
        pointer-events: none;
        background-color: #e9ecef; /* Optional: grey out for a disabled appearance */
		color: #6c757d;
    }

    .dt-hide {
        display: none;
    }
</style>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Tower.tower_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tower
				$form_id = array(
					'id'=>'form_tower',
				);
				echo form_open_multipart('',$form_id);
				$towerId = (isset($tower_data['tower_id']) && ($tower_data['tower_id'] != '')) ? $tower_data['tower_id'] : '';
				?>
				<input type="hidden" id="tower_id" name="tower_id" value="<?= $towerId ?>">
					
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Tower.tower_name');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="tower_name" id="tower_name" placeholder="Enter <?= lang('Tower.tower_name');?>" value="<?= (isset($tower_data['tower_name']) && ($tower_data['tower_name'] != '')) ? $tower_data['tower_name'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($tower_data['is_active']) || $tower_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>

					<hr class="my-4 mx-n4" />

					<h6>2. <?= lang('Tower.add_unit'); ?></h6>
					<div class="row g-3">
						<?= isset($tower_unit_table) ? $tower_unit_table : ""; ?>
					</div>
					<?php if ($dtCIAcl->checkAccess('Tower|manage')) { ?>
						<button type="button" class="btn btn-xs btn-primary" onclick="addTowerUnit()">
							<i class="ti ti-plus me-1"></i>
							<span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
						</button>
					<?php } ?>

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Tower'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	
	function towerUnitValidation() {
		addValidation("input", ".dt-unit", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('Tower.unit');?>",
			}
		});
		addValidation("input", ".dt-unit-group", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('Tower.unit_group');?>",
			}
		});
		addValidation("select", ".dt-number-type", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Tower.number_type');?>",
			}
		});
	}
    $(document).ready(function() {
    	numberInit();
    	$(".dt-number-type").select2();
    	addSerialNumber('tower_unit_table');
		switcheryKeyGen("datatable-list-switchery");
		$('.dt-number-type').trigger('change');
        // Initialize
		var validator = $("#form_tower").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				
				tower_name: {
					required: true
				},
            },
            messages: {
				
				tower_name: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Tower.tower_name');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Tower/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');

					},
					complete: function () {
						//dtButtonShow('#submitBtn');
					},	
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
                                    dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Tower');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Tower');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
		towerUnitValidation();
    });

	$(document).on('change', '.dt-number-type', function() {
	    var numberType = $(this).val(); // Get the selected number type
	    var row = $(this).closest('tr'); // Get the closest row (tr) that contains this dropdown

	    // Select the corresponding Range Label and Range Start From fields in this row
	    var rangeLabelField = row.find('.dt-range-label');
	    var rangeStartFromField = row.find('.dt-range-start-from');

	    if (numberType === 'range') {
	        // If 'range' is selected, show the fields
	        rangeLabelField.show();
	        rangeStartFromField.show();
	    } else {
	        // If 'manual' or other types are selected, hide the fields
	        rangeLabelField.hide();
	        rangeStartFromField.hide();
	    }

	    // Additional logic to ensure visibility based on the entire table's context
	    var shouldShow = false;

	    $('.dt-number-type').each(function() {
	        if ($(this).val() === 'range') {
	            shouldShow = true;
	        }
	    });

	    if (shouldShow) {
	        // Show all fields that have 'range' selected
	        $('.dt-number-type').each(function() {
	            var thisRow = $(this).closest('tr');
	            var thisRangeLabel = thisRow.find('.dt-range-label');
	            var thisRangeStartFrom = thisRow.find('.dt-range-start-from');

	            if ($(this).val() === 'range') {
	                thisRangeLabel.show();
	                thisRangeStartFrom.show();
	            }
	        });
	    }
	});

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
