<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('TimeSlot.time_slot_detail'); ?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id' => 'form_time_slot',
				);
				echo form_open_multipart('', $form_id);
				$timeSlotId = (isset($time_slot_data['time_slot_id']) && ($time_slot_data['time_slot_id'] != '')) ? $time_slot_data['time_slot_id'] : '';
				?>
				<input type="hidden" id="time_slot_id" name="time_slot_id" value="<?= $timeSlotId ?>">

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('TimeSlot.time_slot_name');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">	
						<input type="text" class="form-control" name="time_slot_name" id="time_slot_name" placeholder="Enter <?= lang('TimeSlot.time_slot_name');?>" value="<?= (isset($time_slot_data['time_slot_name']) && ($time_slot_data['time_slot_name'] != '')) ? $time_slot_data['time_slot_name'] : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('TimeSlot.start_time'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="time" class="form-control" name="start_time" id="start_time" placeholder="Enter <?= lang('TimeSlot.start_time'); ?>" value="<?= (isset($time_slot_data['start_time']) && ($time_slot_data['start_time'] != '')) ? ($time_slot_data['start_time']) : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('TimeSlot.end_time'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">

                        <input type="time" class="form-control" name="end_time" id="end_time" placeholder="Enter <?= lang('TimeSlot.end_time'); ?>" value="<?= (isset($time_slot_data['end_time']) && ($time_slot_data['end_time'] != '')) ? ($time_slot_data['end_time']) : '';  ?>" />

                        <?php /*
                        <input type="time" class="form-control" name="end_time" id="end_time" placeholder="Enter <?= lang('TimeSlot.end_time'); ?>" value="<?= (isset($time_slot_data['end_time']) && ($time_slot_data['end_time'] != '')) ? date("h:i A", strtotime($time_slot_data['end_time'])) : '';  ?>" />
  */ ?>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active'); ?></label>
					<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery" name="is_active" id="is_active" 
							<?php echo (!isset($time_slot_data['is_active']) || $time_slot_data['is_active'] == 1) ? 'checked="checked"' : ''; ?> />
							<span class="switch-toggle-slider">
								<span class="switch-on"></span>
								<span class="switch-off"></span>
							</span>

						</label>
					</div>
				</div>

				<div class="pt-4">
					<button type="submit" class="btn btn-primary me-sm-3 me-1">Submit</button>
					<button type="button" onclick="window.location.href='<?php echo admin_url('TimeSlot'); ?>'" class="btn btn-label-secondary">Cancel</button>
				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	function startTime() {
		$('#start_time').flatpickr({
			enableTime: true,
			noCalendar: true,
            dateFormat: "h:i K"
		});
	}

	function endTime() {
		$('#end_time').flatpickr({
			enableTime: true,
			noCalendar: true,
            dateFormat: "h:i K"
		});
	}
	$(document).ready(function() {
		numberInit();
		switcheryKeyGen("datatable-list-switchery");
		// Initialize
		var validator = $("#form_time_slot").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				time_slot_name: {
					required: true,
				},
				start_time: {
					required: true,
				},
				end_time: {
					required: true,
				},
			},
			messages: {
				time_slot_name: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('TimeSlot.time_slot_name'); ?>"
				},
				start_time: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('TimeSlot.start_time'); ?>"
				},
				end_time: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('TimeSlot.end_time'); ?>"
				},
			},
			submitHandler: function(e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("TimeSlot/save"); ?>',
					type: 'post',
					beforeSubmit: function(formData, jqForm, options) {

					},
					complete: function() {

					},
					dataType: 'json',
					clearForm: false,
					success: function(resObj, statusText) {
						if (resObj.success) {
							Swal.fire({
								title: 'Success',
								text: resObj.msg,
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								window.location.href = '<?php echo admin_url('TimeSlot'); ?>';
							});

						} else {
							Swal.fire({
								title: 'Error!',
								text: resObj.msg,
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							});
						}
					}
				});
			}
		});

		startTime();
		endTime();
	});
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>