<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$isSuperAdmin = session('is_super_admin');

$prefix = session('is_super_admin') ? 'SuperAdmin/Society' : 'Admin/Society';
$editSocietyUrl = site_url($prefix . "/manage");
?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>

<div class="card">
    <div class="card-datatable table-responsive text-nowrap">
        <table id="society_table" class="table dt-datatable dt-scrollableTable">
            <thead class="border-top">
            <tr>
                <th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
                <th class="font-weight-bold"><?= lang("Society.society_name"); ?></th>
                <?php if($isSuperAdmin !== 1){?>
                <th class="font-weight-bold"><?= lang("Society.total_towers"); ?></th>
                <th class="font-weight-bold"><?= lang("Society.total_flats"); ?></th>
                <?php } ?>
                <th class="font-weight-bold"><?= lang("Society.tp_no"); ?></th>
                <th class="font-weight-bold"><?= lang("Society.district"); ?></th>
                <th class="font-weight-bold"><?= lang("Society.postal_address"); ?></th>
                <th class="font-weight-bold"><?= lang("Society.sf_area"); ?></th>
                <th class="font-weight-bold"><?= lang("Society.registration_no"); ?></th>
                <th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_active"); ?></th>
                
                <th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
                <?php /*
                */?>
            </tr>
            </thead>
        </table>
    </div>
    <!--	</div>-->
</div>
<?= isset($v_society_modal) ? $v_society_modal : "" ; ?>
<script type="text/javascript">
    var dt_DataTable;

    $(document).ready(function () {
        dt_DataTable = $('#society_table').DataTable( {
            dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
                '<"me-5 ms-n2 pe-5"f>' +
                '<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
                '>t' +
                '<"row mx-2"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            processing: true,
            serverSide: true,
            displayLength: 10,
            scrollX: true,
            // language: {
            // 	sLengthMenu: 'Show _MENU_',
            // 	search: '',
            // 	searchPlaceholder: 'Search Society'
            // },
            language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search <?= lang("Society.society"); ?>',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },

            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
                    text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
                    buttons: [
                        {
                            text: '<i class="ti ti-file me-2" ></i>Excel',
                            className: 'dropdown-item dt-excel-export'
                        },
                        // {
                        // 	extend: 'pdf',
                        // 	text: '<i class="ti ti-file-text me-2"></i>Pdf',
                        // 	className: 'dropdown-item',
                        //
                        // }
                    ]
                },
                <?php if ($dtCIAcl->checkAccess("Society|manage")) { ?>
                {
                    text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Society.add_society');?></span>',
                    className: 'add-new btn btn-primary px-1 me-2',
                    action: function () {
                        window.location.href = '<?= $editSocietyUrl;?>';
                    }
                },
                <?php } ?>
                <?php 
                if(empty($isSuperAdmin)){
                    if ($dtCIAcl->checkAccess("Society|delete")) { ?>
                    {
                        text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Society.delete_society');?></span>',
                        //className: 'btn btn-danger ms-2 ms-sm-0 waves-effect waves-light dt-delete-record invisible',
                        className: 'btn btn-danger  px-1 dt-delete-record',
                    },
                // {
                // 	text: '<span class="ti ti-trash"></span>',
                // 	className: 'add-new  ms-2 ms-sm-0 waves-effect waves-light rounded-pill btn btn-icon btn-danger dt-delete-record',
                // },
                <?php } } ?>
            ],
            "ajax": {
                "url": "<?php echo admin_url('Society/getSocietyListing'); ?>",
                "type": "POST",
                "data": function ( d ) {

                }
            },
            "stateSave": true,
			"order": [[ 0, "asc" ]],
            "columns": [
                {
                    "data": "society_id",
                    "render": function (data, type, row) {
                        return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['society_id'] + '" name="ids[]" value="' + row['society_id'] + '"/>';
                    },
                    "sortable": false,
                    "searchable": false,
                    "class": "no_click_allowed"
                },
                {"data": "society_name"},
                <?php if($isSuperAdmin !== 1){?>
                {"data": "total_tower"},
                {"data": "total_flats"},
                <?php } ?>
                {"data": "tp_no"},
                {"data": "district"},
                {"data": "postal_address"},
                {"data": "sf_area"},
                {"data": "registration_no"},
                {"data": "updated_by"},
				{"data": "updated_at"},
                {
                    "data": "is_active",
                    "sortable": false,
                    "searchable": false,
                    "class": "no_click_allowed",
                    "render": function (data, type, row) {
                        var checked = (data == 1) ? "checked" : "";
                        return '<label class="switch switch-primary switch-sm">' +
                            '<input type="checkbox" class="switch-input  dt-active-status" ' + checked + '  data-id="' + row['society_id'] + '" value="1" />' +
                            '<span class="switch-toggle-slider">' +
                            '<span class="switch-on"></span>' +
                            '<span class="switch-off"></span>' +
                            '</span>'+
                        '</label>';

                    }
                },
                {
                    "data": "action_button",
                    "class" : "text-center",
                    "sortable": false,
                    "searchable": false,
                    "class": "no_click_allowed"
                },
            ],
            createdRow: function (row, data, dataIndex) {
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").addClass('dt-detail-model-view');
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_id', data['society_id']);
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_url', '<?= admin_url("Society/view"); ?>');
			},
            "fnDrawCallback": function (oSettings, json) {
                customToolTip();
                $('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
                $('.dt-buttons').addClass('d-flex flex-wrap');
                $('.dataTables_filter .form-control').removeClass('form-control-sm');
                $('.dataTables_length .form-select').removeClass('form-select-sm');
                //checkBoxRefresh("datatable-checkbox");
                switcheryKeyGen("datatable-list-switchery");

            }
        });
        dtDataTableSearch();

    });

    $(document).on('click', '.dt-active-status', function () {
        var id = $(this).attr('data-id');
        var isActive = $(this).is(":checked") ? 1 : 0;
        $.ajax({
            type: 'post',
            url: '<?php echo admin_url('Society/changeStatus'); ?>',
            data: {society_id:id, status: isActive},
            dataType: 'json',
            success: function (data) {
                if (data) {
                    Swal.fire({
                        title: 'Success',
                        text: data.msg,
                        icon: 'success',
                        customClass: {
                            confirmButton: 'btn btn-primary waves-effect waves-light'
                        },
                        buttonsStyling: false
                    }).then(function() {
                        dt_DataTable.ajax.reload(null,false);
                    });
                } else {
                    Swal.fire({
                        title: 'Error!',
                        text: data.msg,
                        icon: 'error',
                        customClass: {
                            confirmButton: 'btn btn-primary waves-effect waves-light'
                        },
                        buttonsStyling: false
                    });
                }
            }
        });
    });

    //Delete Record
    $(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#society_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("Society/delete")?>",
                        dataType: "json",
                        data: {society_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });

    $(document).on('click', '.form-status', function () {
        var societyId = $(this).attr('id').split("_").pop();
        //var series = $(this).closest("tr").find(".dt-series").text();
        var series = 'S1';
        var status = $(this).attr('data-value');
        bootbox.confirm("<?= lang('common_permanently_submit'); ?> " + series + "?", function (result) {
            if (result) {
                $.ajax({
                    type: "post",
                    url: "<?= admin_url("Society/submitForm")?>",
                    dataType: "json",
                    data: {society_id: societyId, form_status: status},
                    beforeSend: function (formData, jqForm, options) {
                        Swal.fire({
                            text: '<?= lang('CommonMessage.ajax_data_loading_message');?>',
                            showConfirmButton: false,
                            allowOutsideClick: false
                        });
                    },
                    complete: function () {
                        //bootbox.hideAll();
                    },
                    success: function (data) {
                        if (data['success']) {
                            Swal.fire({
                                title: 'Success',
                                text: data['msg'],
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                                dt_DataTable.ajax.reload(null,false);
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: data['msg'],
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-danger waves-effect waves-light'
                                },
                                buttonsStyling: false
                            });
                        }
                    }
                });
            }
        });
    });

    $(document).on('click', '.datatable-checkbox', function () {
        $(".dt-delete-record").removeClass( "invisible" );
    });

    $(document).on('click', '.dt-excel-export', function() {
        $(this).removeClass(".dt-excel-export");
        var dataTableParams = dt_DataTable.ajax.params();
        url = '<?= site_url(session('is_super_admin') ? 'SuperAdmin/Society/excelExportSociety' : 'Admin/Society/excelExportSociety'). ""  ?>';
        var recursiveEncoded = $.param(dataTableParams);
        $('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
        $('.dt-export-anchor')[0].click();
    });
</script>
