<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$isSuperAdmin = session('is_super_admin');
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Society.society_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_society',
				);
				echo form_open_multipart('',$form_id);
				$societyId = (isset($society_data['society_id']) && ($society_data['society_id'] != '')) ? $society_data['society_id'] : '';
				?>
				<input type="hidden" id="society_id" name="society_id" value="<?= $societyId ?>">

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.society_name');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="society_name" id="society_name" placeholder="Enter <?= lang('Society.society_name');?>" value="<?= (isset($society_data['society_name']) && ($society_data['society_name'] != '')) ? $society_data['society_name'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.email');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="email" class="form-control" name="email" id="email" placeholder="Enter <?= lang('Society.email');?>" value="<?= (isset($society_data['email']) && ($society_data['email'] != '')) ? $society_data['email'] : '';  ?>" />
						</div>
					</div>
					
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.contact');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="contact" class="form-control numberInit" name="contact" id="contact" placeholder="Enter <?= lang('Society.contact');?>" value="<?= (isset($society_data['contact']) && ($society_data['contact'] != '')) ? $society_data['contact'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.s_no');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="s_no" id="s_no" placeholder="Enter <?= lang('Society.s_no');?>" value="<?= (isset($society_data['s_no']) && ($society_data['s_no'] != '')) ? ($society_data['s_no']) : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.tp_no');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="tp_no" id="tp_no" placeholder="Enter <?= lang('Society.tp_no');?>" value="<?= (isset($society_data['tp_no']) && ($society_data['tp_no'] != '')) ? ($society_data['tp_no']) : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.fp_no');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="fp_no" id="fp_no" placeholder="Enter <?= lang('Society.fp_no');?>" value="<?= (isset($society_data['fp_no']) && ($society_data['fp_no'] != '')) ? ($society_data['fp_no']) : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.area');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="area" id="area" placeholder="Enter <?= lang('Society.area');?>" value="<?= (isset($society_data['area']) && ($society_data['area'] != '')) ? $society_data['area'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.taluka');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="taluka" id="taluka" placeholder="Enter <?= lang('Society.taluka');?>" value="<?= (isset($society_data['taluka']) && ($society_data['taluka'] != '')) ? $society_data['taluka'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.state');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="state" id="state" placeholder="Enter <?= lang('Society.state');?>" value="<?= (isset($society_data['state']) && ($society_data['state'] != '')) ? $society_data['state'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.district');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="district" id="district" placeholder="Enter <?= lang('Society.district');?>" value="<?= (isset($society_data['district']) && ($society_data['district'] != '')) ? $society_data['district'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.opp');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="opp" id="opp" placeholder="Enter <?= lang('Society.opp');?>" value="<?= (isset($society_data['opp']) && ($society_data['opp'] != '')) ? $society_data['opp'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.postal_address');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<textarea name="postal_address"  id="postal_address" placeholder="Enter <?= lang('Society.postal_address'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($society_data['postal_address']) && ($society_data['postal_address'] != '')) ? $society_data['postal_address'] : ''; ?></textarea>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.towers');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="towers" id="towers" placeholder="Enter <?= lang('Society.towers');?>" value="<?= (isset($society_data['towers']) && ($society_data['towers'] != '')) ? ($society_data['towers']) : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.flats');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="flats" id="flats" placeholder="Enter <?= lang('Society.flats');?>" value="<?= (isset($society_data['flats']) && ($society_data['flats'] != '')) ? ($society_data['flats']) : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.sf_area');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="sf_area" id="sf_area" placeholder="Enter <?= lang('Society.sf_area');?>" value="<?= (isset($society_data['sf_area']) && ($society_data['sf_area'] != '')) ? ($society_data['sf_area']) : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.registration_no');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="registration_no" id="registration_no" placeholder="Enter <?= lang('Society.registration_no');?>" value="<?= (isset($society_data['registration_no']) && ($society_data['registration_no'] != '')) ? $society_data['registration_no'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.tan');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="tan" id="tan" placeholder="Enter <?= lang('Society.tan');?>" value="<?= (isset($society_data['tan']) && ($society_data['tan'] != '')) ? $society_data['tan'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.pan');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="pan" id="pan" placeholder="Enter <?= lang('Society.pan');?>" value="<?= (isset($society_data['pan']) && ($society_data['pan'] != '')) ? $society_data['pan'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.gst');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="gst" id="gst" placeholder="Enter <?= lang('Society.gst');?>" value="<?= (isset($society_data['gst']) && ($society_data['gst'] != '')) ? $society_data['gst'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.invoice_note');?><span class="text-danger"> </span></label>
						<div class="col-sm-10">	
							<textarea class="form-control invoice_note " name="invoice_note" id="invoice_note" rows="5" cols="5"  placeholder="Enter <?= lang('Society.invoice_note'); ?>" rows="10" cols="10"  class="form-control invoice_note"><?= (isset($society_data['invoice_note']) && ($society_data['invoice_note'] != '')) ? $society_data['invoice_note'] : ''; ?></textarea>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.logo');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<input type="file" accept="image/*" class="form-control" name="logo" >
							<span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span><br>
							<?php 
		                    if(isset($society_data['logo']) && !empty($society_data['logo'])){
		                        if(file_exists(SOCIETY_IMAGE_PATH . $society_data['logo'])){
		                        	$thumbnailPaths = site_url() . THUMBNAIL_SOCIETY_IMAGE_PATH . $society_data['logo'];
				                    $paths = site_url() . SOCIETY_IMAGE_PATH . $society_data['logo']; ?> &nbsp;&nbsp;&nbsp;
				                	<span class="document-logo ?>">
				                		<a href="<?= $paths; ?>" target="_blank"> 
											<img src="<?= $thumbnailPaths; ?>" width="100" class="img-fluid" alt=""> 
										</a>
				        			</span>
		            			<?php }
							} ?>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Society.society_image');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<input type="file" accept="image/*" class="form-control" name="society_image[]" multiple="multiple">
							<span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span><br>
							<?php 
		                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
		                        foreach($image_data as $image) { 
		                        	if(file_exists(SOCIETY_IMAGE_PATH . $image['society_image'])){
		                        		$thumbnailPaths = site_url() . THUMBNAIL_SOCIETY_IMAGE_PATH . $image['society_image'];
				                        $paths = site_url() . SOCIETY_IMAGE_PATH . $image['society_image']; ?> &nbsp;&nbsp;&nbsp;
				                 		<span class="document-image-<?= $image['society_image_id']; ?>">
				                 			<a href="<?= $paths; ?>" target="_blank"> 
												<img src="<?= $thumbnailPaths; ?>" width="100" class="img-fluid" alt=""> 
												<?php if(!empty($societyId) && $dtCIAcl->checkAccess('Society|deleteImage')) {?>
													<a href="javascript:void(0);"  id="<?php echo $image['society_image_id']; ?>" class="btn btn-icon btn-outline-dribbble delete-image"> <i class="tf-icons ti ti-trash"></i> </a> 
												<?php }?>
											</a>
				        				</span>
		            		<?php }} } ?>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($society_data['is_active']) || $society_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?= site_url(session('is_super_admin') ? 'SuperAdmin/Society' : 'Admin/Society') ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		switcheryKeyGen("datatable-list-switchery");
		ckEditorInit('invoice_note');
        // Initialize
		var validator = $("#form_society").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				society_name : {
					required : true,
				},
				s_no : {
					required : true,
				},
                tp_no: {
                    required: true,
                },
                fp_no : {
					required : true,
				},
                area: {
                    required: true,
                },
                taluka : {
					required : true,
				},
                district: {
                    required: true,
                },
                state: {
                    required: true,
                },
                towers : {
					required : true,
				},
                flats: {
                    required: true,
                },
                opp: {
                    required: true,
                },
                flats: {
                    required: true,
                },
                sf_area : {
					required : true,
				},
                registration_no: {
                    required: true,
                },
                tan: {
                    required: true,
                },
                pan: {
                    required: true,
                },
                gst: {
                    required: true,
                },
                postal_address: {
                    required: true,
                },
				<?php
        		if($societyId == '') { ?>
					"society_image[]":{
						required : true,
	                },
            	<?php } ?>
				
            },
            messages: {
				society_name: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Society.society_name');?>"
				},
				s_no : {
					required : "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.s_no');?>"
				},
                tp_no: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.tp_no');?>"
                },
                fp_no : {
					required : "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.fp_no');?>"
				},
                area: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.area');?>"
                },
                opp: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.opp');?>"
                },
                taluka : {
					required : "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.taluka');?>"
				},
                district: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.district');?>"
                },
                state: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.state');?>"
                },
                towers : {
					required : "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.towers');?>"
				},
                flats: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.flats');?>"
                },
                sf_area : {
					required : "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.sf_area');?>"
				},
                registration_no: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.registration_no');?>"
                },
                tan: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.tan');?>"
                },
                pan: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.pan');?>"
                },
                gst: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.gst');?>"
                },
                postal_address: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Society.postal_address');?>"
                },
				<?php
        		if($societyId == '') { ?>
					"society_image[]":{
						required : '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Society.society_image"); ?>',
	                },
	            <?php } ?>
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Society/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {
                        //dtButtonShow('#submitBtn');
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
									dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    // window.location.href = '<?php echo admin_url('Society');?>';

                                    let prefix = '<?= session('is_super_admin') ? 'SuperAdmin/Society' : 'Admin/Society' ?>';
                                    window.location.href = '<?= site_url() ?>' + prefix;
                                }
							});
							//setTimeout(function () {
							//	///window.location.href = '<?php //echo admin_url('Society');?>//';
							//}, 1000);
						} else {
                            dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
						    toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});

						}
					}
				});
            }
        });
        $("#society_date_time").flatpickr({
			// monthSelectorType: 'static',
    		enableTime: true,
    		dateFormat: "d-m-Y H:i",
			// dateFormat: 'd-m-Y'
		});
    });

	$(document).on('click', '.delete-image', function () {
        var deleteId = $(this).attr("id");
		var societyId = $("#society_id").val();
        Swal.fire({
			title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
			text: "<?= lang('CommonMessage.delete_warning'); ?>",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'OK',
			customClass: {
				confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
				cancelButton: 'btn btn-label-secondary waves-effect waves-light'
			},
			buttonsStyling: false
		}).then(function(result) {
			if (result.value) {
				$("span.document-image-"+deleteId).remove();
		        $.ajax({
		            type: "post",
		            url: "<?= admin_url("Society/deleteSocietyImage")?>",
		            dataType: "json",
		            data: {society_image_id: deleteId,society_id:societyId},
		            success: function (data) {
		                if (data['success']) {
		                    $(".delete-image").click(function() {
		                        $(this).parent().remove();
		                    }); 
			                Swal.fire({
								title: 'Success',
								text: data['msg'],
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		                else{
		                    Swal.fire({
								title: 'Error!',
								text: data['msg'],
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		            }
		        });
		    }
		});
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
