<?php
$assets = base_url() . 'assets/';
$societyData = !empty($society_data) && is_array($society_data) ? $society_data : array(); ?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?= $name; ?></title>
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
		  type="text/css">

	<link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
	<link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>

<body style='font-family:chelvetica;font-size: 9px'>
<div class="row">
	<div class="col-xs-12">
		<h3 style="color: red;text-align: center;"><?= lang('Society.society_summary'); ?></h3>
		<table class="table" width="100%" cellspacing="0" cellpadding="0">
			<tbody>
			<tr>
				<td>
					<table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
						<tbody>
						<tr>
							<td colspan="6"><center><strong><?= isset($societyData["society_name"]) ? ($societyData["society_name"]) : ""; ?></strong></center></td>
							<td><center><strong><?= lang("Society.towers"); ?> </strong></center></td>
							<td><center><?= isset($societyData["towers"]) ? ($societyData["towers"]) : ""; ?></center></td>
						</tr>
						<tr>
							<td><center><strong><?= lang("Society.s_no"); ?> </strong>: &nbsp;<?= isset($societyData["s_no"]) ? ($societyData["s_no"]) : ""; ?></center></td>
							<td><center><strong><?= lang("Society.tp_no"); ?> </strong>: &nbsp;<?= isset($societyData["tp_no"]) ? ($societyData["tp_no"]) : ""; ?></center></td>
							<td><center><strong><?= lang("Society.fp_no"); ?> </strong>: &nbsp;<?= isset($societyData["fp_no"]) ? ($societyData["fp_no"]) : ""; ?></center></td>
							<td><center><strong><?= lang("Society.area"); ?> </strong>: &nbsp;<?= isset($societyData["area"]) ? ($societyData["area"]) : ""; ?></center></td>
							<td><center><strong><?= lang("Society.taluka"); ?> </strong>: &nbsp;<?= isset($societyData["taluka"]) ? ($societyData["taluka"]) : ""; ?></center></td>
							<td><center><strong><?= lang("Society.district"); ?> </strong>: &nbsp;<?= isset($societyData["district"]) ? ($societyData["district"]) : ""; ?></center></td>
							<td><center><strong><?= lang("Society.flats"); ?> </strong></td>
							<td><center><?= isset($societyData["flats"]) ? ($societyData["flats"]) : ""; ?></center></td>
						</tr>
						<tr>
							<td colspan="6"><strong><?= lang("Society.postal_address"); ?></strong> : &nbsp;<?= isset($societyData["postal_address"]) ? ($societyData["postal_address"]) : ""; ?></td>
							<td><center><strong><?= lang("Society.sf_area"); ?> </strong></center></td>
							<td><center><?= isset($societyData["sf_area"]) ? ($societyData["sf_area"]) : ""; ?></center></td>
						</tr>
						<tr class="header-row">
							<td colspan="4"><center><strong><?= lang("Society.registration_no"); ?></strong></center></td>
							<td colspan="4"><center><?= isset($societyData["registration_no"]) ? ($societyData["registration_no"]) : ""; ?></center></td>
						</tr>
						<tr>
							<td colspan="4"><center><strong><?= lang("Society.pan"); ?></strong></center></td>
							<td colspan="4"><center><?= isset($societyData["pan"]) ? ($societyData["pan"]) : ""; ?></center></td>
						</tr>
						<tr>
							<td colspan="4"><center><strong><?= lang("Society.tan"); ?></strong></td>
							<td colspan="4"><center><?= isset($societyData["tan"]) ? ($societyData["tan"]) : ""; ?></center></td>
						</tr>
						<tr>
							<td colspan="4"><center><strong><?= lang("Society.gst"); ?></strong></td>
							<td colspan="4"><center><?= isset($societyData["gst"]) ? ($societyData["gst"]) : ""; ?></center></td>
						</tr>
						</tbody>
					</table>
				</td>
			</tr>
			</tbody>
		</table>

		<?php if (isset($bank_data) && !empty($bank_data)) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Society.bank_details') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 10%">
						<center><?= lang('CommonMessage.common_sn'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.account_number'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.account_type'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.name_of_bank'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.branch'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.ifsc'); ?></center>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($bank_data) && !empty($bank_data)) {
					foreach ($bank_data as $key => $value) {
						?>
						<tr>
							<td>
								<center><?= ++$key; ?></center>
							</td>
							<td>
								<center><?= isset($value['bank_account_no']) ? $value['bank_account_no'] : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['bank_account_type']) ? underscoreToUcWord($value['bank_account_type']) : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['bank_name']) ? $value['bank_name'] : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['branch']) ? $value['branch'] : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['ifsc_code']) ? $value['ifsc_code'] : ''; ?></center>
							</td>
						</tr>
						<?php
					}
				} else {
					echo "<tr><td colspan='9' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>

		<?php if (isset($amenities_data) && !empty($amenities_data) ) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Society.amenities_details') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 10%">
						<center><?= lang('CommonMessage.common_sn'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.amenities_name'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.total_quantity'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.situated_at'); ?></center>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($amenities_data) && !empty($amenities_data)) {
					foreach ($amenities_data as $key => $value) {
						if ($value['type'] == 'amenities'){
						?>
						<tr>
							<td>
								<center><?= ++$key; ?></center>
							</td>
							<td>
								<center><?= isset($value['amenities_name']) ? $value['amenities_name'] : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['total_quantity']) ? $value['total_quantity'] : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['common_area_name']) ? $value['common_area_name'] : ''; ?></center>
							</td>
						</tr>
						<?php
						}
					}
				} else {
					echo "<tr><td colspan='9' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>

		<?php if (isset($facilities_data) && !empty($facilities_data) ) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Society.facilities_details') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 10%">
						<center><?= lang('CommonMessage.common_sn'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.facilities_name'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.total_quantity'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.situated_at'); ?></center>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($facilities_data) && !empty($facilities_data)) {
					foreach ($facilities_data as $key => $value) {
						?>
						<tr>
							<td>
								<center><?= ++$key ; ?></center>
							</td>
							<td>
								<center><?= isset($value['amenities_name']) ? $value['amenities_name'] : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['total_quantity']) ? $value['total_quantity'] : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['common_area_name']) ? $value['common_area_name'] : ''; ?></center>
							</td>
						</tr>
						<?php
						}
				} else {
					echo "<tr><td colspan='9' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>

		<?php if (isset($charges_data) && !empty($charges_data)) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Society.charges_details') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 10%">
						<center><?= lang('CommonMessage.common_sn'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.charges_name'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.amount'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.tax'); ?></center>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($charges_data) && !empty($charges_data)) {
					foreach ($charges_data as $key => $value) {
						?>
						<tr>
							<td>
								<center><?= ++$key; ?></center>
							</td>
							<td>
								<center><?= isset($value['charges_name']) ? $value['charges_name'] : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['amount']) ? ($value['amount']) : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['tax_name']) ? $value['tax_name'] : ''; ?></center>
							</td>
						</tr>
						<?php
						}
				} else {
					echo "<tr><td colspan='9' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>

		<?php if (isset($penalties_data) && !empty($penalties_data)) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Society.penalties_details') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 10%">
						<center><?= lang('CommonMessage.common_sn'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.penalties_name'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.amount'); ?></center>
					</td>
					<td class="text-bold">
						<center><?= lang('Society.tax'); ?></center>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($penalties_data) && !empty($penalties_data)) {
					foreach ($penalties_data as $key => $value) {
						?>
						<tr>
							<td>
								<center><?= ++$key; ?></center>
							</td>
							<td>
								<center><?= isset($value['charges_name']) ? $value['charges_name'] : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['amount']) ? ($value['amount']) : ''; ?></center>
							</td>
							<td>
								<center><?= isset($value['tax_name']) ? $value['tax_name'] : ''; ?></center>
							</td>
						</tr>
						<?php
						}
				} else {
					echo "<tr><td colspan='9' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>
	</div>
</div>
</body>
</html>
