<div class="table-responsive text-nowrap">
	<table id="withdrawn_details_table" class="table table-bordered" data-sinking-fund-id="<?= $sinking_fund_id ?>">
		<thead>
			<tr>
				<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
				<th style="width: 10%"><?= lang("SinkingFund.withdraw_date"); ?></th>
				<th style="width: 10%"><?= lang("SinkingFund.amount"); ?></th>
				<th style="width: 10%"><?= lang("SinkingFund.remarks"); ?></th>
				<th style="width: 10%"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
		</thead>
		<tbody class="">
        	<?php if($sinking_fund_withdrawn_data != '' && array_filter($sinking_fund_withdrawn_data)) {
            $sr = 1;
            foreach ($sinking_fund_withdrawn_data as $key => $value) { ?>
				<tr>
					<td class="text-center"><?= $sr; ?></td>
                    <td colspan="1"><?= YMDToDMY($value['withdrawn_date']); ?> </td>
                    <td colspan="1"><?= ($value['amount']); ?> </td>
                    <td colspan="1"><?= ($value['remarks']); ?> </td>

                    <td colspan="1">
					    <!-- EDIT Button -->
					    <a href="javascript:void(0);" 
					       data-bs-toggle="tooltip" 
					       data-id="<?= $value['sinking_fund_withdrawn_id'] ?>" 
					       data-bs-placement="top" 
					       data-bs-custom-class="custom-tooltip" 
					       title="<?= lang('SinkingFund.edit_withdrawn'); ?>" 
					       class="btn btn-sm btn-icon edit-withdrawn">
					        <i class="ti ti-pencil"></i>
					    </a>

					    <!-- DELETE Button -->
					    <a href="javascript:void(0);"
					       class="btn btn-sm btn-icon text-danger delete-withdrawn"
					       data-id="<?= $value['sinking_fund_withdrawn_id']; ?>"
					       title="<?= lang('CommonMessage.common_delete'); ?>">
					        <i class="ti ti-trash"></i>
					    </a>
					</td>
				</tr>
            <?php $sr++;} }  else {   ?>
				<tr>
					<td colspan="5" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
				</tr>
			<?php } ?>
		</tbody>
	</table>
</div>
	
<script type="text/javascript">
	$(document).on('click', '.edit-withdrawn', function () {
	    var sinkingFundWithdrawnId = $(this).data('id');

	    $.ajax({
	        url: '<?= admin_url("SinkingFund/getSinkingFundWithdrawnData"); ?>',
	        type: 'POST',
	        data: { sinking_fund_withdrawn_id: sinkingFundWithdrawnId },
	        dataType: 'json',
	        success: function (response) {
	        	console.log(response);
	            if (response.success) {
	            	$('#view_module_detail').modal('hide'); 
	                $('#sinking_fund_withdrawn_id').val(response.data.sinking_fund_withdrawn_id);
	                $('#sinking_funds_id').val(response.data.sinking_fund_id);

	                var onDate = response.data.withdrawn_date;
					var parts = onDate.split('-');
					var formattedDate = parts[2] + '-' + parts[1] + '-' + parts[0];
	                $('#withdrawn_date').val(formattedDate);
	                $('#amounts').val(response.data.amount);
	                $('#remarks').val(response.data.remarks);
	                $('#withdrawn_modal').modal('show');
	            } else {
	                alert("<?= lang('CommonMessage.common_error_occurred'); ?>");
	            }
	        }
	    });
	});

	$(document).on('click', '.delete-withdrawn', function () {
	    var sinkingFundWithdrawnId = $(this).data('id');
	    var sinkingFundId = $('#withdrawn_details_table').data('sinking-fund-id');
	    Swal.fire({
            title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
            text: "<?= lang('CommonMessage.delete_warning'); ?>",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
            customClass: {
                confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                cancelButton: 'btn btn-label-secondary waves-effect waves-light'
            },
            buttonsStyling: false
        }).then(function(result) {
            if (result.value) {
            	$.ajax({
                    type: "post",
                    url: "<?= admin_url("SinkingFund/deleteWithdrawn")?>",
                    dataType: "json",
                    data: {sinking_fund_withdrawn_id: sinkingFundWithdrawnId},
                    success: function (data) {
                        if (data['success']) {
                            Swal.fire({
                                title: 'Success',
                                text: data['msg'],
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                            	dt_DataTable.ajax.reload();
                                reloadWithdrawnTable(sinkingFundId);
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: data['msg'],
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                            	dt_DataTable.ajax.reload();
                                reloadWithdrawnTable(sinkingFundId);
                            });
                        }
                    }
                });
            }
        	else {
                
            }
        });
    });

   	function reloadWithdrawnTable(sinkingFundId) {
	    $.ajax({
	        url: '<?= admin_url("SinkingFund/withdrawnView"); ?>',
	        type: 'GET',
	        data: { view_id: sinkingFundId },
	        dataType: 'json', 
	        success: function (response) {
	            if (response.success && response.view_detail) {
	                $('#withdrawn_details_table').closest('.table-responsive').html(response.view_detail);
	            } else {
	                console.error("Invalid view_detail or success false");
	            }
	        },
	        error: function (xhr, status, error) {
	            console.error("AJAX error:", error);
	        }
	    });
	}


</script>