<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('SinkingFund.sinking_fund_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open sinking_fund
				$form_id = array(
					'id'=>'form_sinking_fund',
				);
				echo form_open_multipart('',$form_id);
				$sinkingFundId = (isset($sinking_fund_data['sinking_fund_id']) && ($sinking_fund_data['sinking_fund_id'] != '')) ? $sinking_fund_data['sinking_fund_id'] : '';
				?>
				<input type="hidden" id="sinking_fund_id" name="sinking_fund_id" value="<?= $sinkingFundId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('SinkingFund.flat');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="flat_id" name="flat_id" class="select2 form-select form-select-lg flatDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($sinking_fund_data['flat_id']) && $sinking_fund_data['flat_id'] != 0){ ?>
                       				 <option value="<?= isset($sinking_fund_data['flat_id']) ? $sinking_fund_data['flat_id'] : 0 ?>" selected> <?= isset($sinking_fund_data['flat_no']) ? $sinking_fund_data['flat_no'] : ''  ?> </option>
                    			<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('SinkingFund.member');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="ownership_flat_member_id" name="ownership_flat_member_id" class="select2 form-select getFlatMemberDd ownerMemberDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($sinking_fund_data['ownership_flat_member_id']) && $sinking_fund_data['ownership_flat_member_id'] != 0){ ?>
								<option value="<?= isset($sinking_fund_data['ownership_flat_member_id']) ? $sinking_fund_data['ownership_flat_member_id'] : 0 ?>" selected> <?= isset($sinking_fund_data['name']) ? $sinking_fund_data['name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('SinkingFund.financial_year');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
						<select id="financial_year_id" name="financial_year_id" class="select2 form-select form-select-lg financialYearDd" data-allow-clear="true">
							<option></option>
							<?php if(isset($sinking_fund_data['financial_year_id']) && $sinking_fund_data['financial_year_id'] != 0){ ?>
								<option value="<?= isset($sinking_fund_data['financial_year_id']) ? $sinking_fund_data['financial_year_id'] : 0 ?>" selected> <?= isset($sinking_fund_data['financial_year_prefix']) ? $sinking_fund_data['financial_year_prefix'] : ''  ?> </option>
							<?php } ?>
						</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('SinkingFund.on_date');?><span class="text-danger"> *</span></label>
							<div class="col-sm-10">
									<input type="text"  name="on_date" id="on_date" class="form-control dt-on-date" placeholder="Select <?= lang('SinkingFund.on_date'); ?>" value="<?= isset($sinking_fund_data['on_date']) ? YMDToDMY($sinking_fund_data['on_date']): ""; ?>"/>
							</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('SinkingFund.for_period');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<input type="text" class="form-control numberInit" name="for_period" id="for_period" placeholder="Enter <?= lang('SinkingFund.for_period');?>" value="<?= (isset($sinking_fund_data['for_period']) && ($sinking_fund_data['for_period'] != '')) ? $sinking_fund_data['for_period'] : '';  ?>" />
						</div>
					</div>


					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('SinkingFund.amount');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<input type="text" class="form-control numberInit" name="amount" id="amount" placeholder="Enter <?= lang('SinkingFund.amount');?>" value="<?= (isset($sinking_fund_data['amount']) && ($sinking_fund_data['amount'] != '')) ? $sinking_fund_data['amount'] : '';  ?>" />
						</div>
					</div>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('SinkingFund'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		flatDd();
		ownerMemberDd();
		financialYearDd();
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_sinking_fund").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				financial_year_id: {
					required: true
				},
				flat_id: {
					required: true
				},
				on_date: {
					required: true
				},
				for_period: {
					required: true
				},
				amount: {
					required: true
				},
				ownership_flat_member_id: {
					required: true
				},
            },
            messages: {
				financial_year_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('SinkingFund.financial_year');?>"
				},
				flat_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('SinkingFund.flat');?>"
				},
				on_date: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('SinkingFund.on_date');?>"
				},
				for_period: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('SinkingFund.for_period');?>"
				},
				amount: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('SinkingFund.amount');?>"
				},
				ownership_flat_member_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('SinkingFund.member');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("SinkingFund/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('SinkingFund');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('SinkingFund');?>';
							// }, 1000);

						} else {
							dtButtonShow("#submitBtn");
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });

	$("#on_date").flatpickr({
			// monthSelectorType: 'static',
    		// enableTime: true,
    		dateFormat: "d-m-Y",
			// dateFormat: 'd-m-Y'
		});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
