<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$isSuperAdmin = session('is_super_admin');
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('ShareFeeReceived.share_fee_received_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_share_fee_received',
				);
				echo form_open_multipart('',$form_id);
				$shareCertificateId = (isset($share_fee_received_data['id']) && ($share_fee_received_data['id'] != '')) ? $share_fee_received_data['id'] : '';
				?>
				<input type="hidden" id="id" name="id" value="<?= $shareCertificateId ?>">

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="receipt_date">
						<?= lang('ShareFeeReceived.receipt_date');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="receipt_date" id="receipt_date"
							placeholder="Select <?= lang('ShareFeeReceived.receipt_date');?>"
							value="<?= (isset($share_fee_received_data['receipt_date']) && isValidDate($share_fee_received_data['receipt_date']))
											? YMDToDMY($share_fee_received_data['receipt_date']) : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="flat_id">
						<?= lang('ShareFeeReceived.flat_no');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<select id="flat_id" name="flat_id" class="select2 form-select flatDd" data-allow-clear="true">
							<option></option>
							<?php if(isset($share_fee_received_data['flat_id']) && $share_fee_received_data['flat_id'] != 0){ ?>
								<option value="<?= $share_fee_received_data['flat_id']; ?>" selected>
									<?= isset($share_fee_received_data['flat_no']) ? $share_fee_received_data['flat_no'] : ''; ?>
								</option>
							<?php } ?>
						</select>
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="bank_account_id">
						<?= lang('ShareFeeReceived.bank_account');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<select id="bank_account_id" name="bank_account_id" class="select2 form-select bankAccountDd" data-allow-clear="true">
							<option></option>
							<?php if(isset($share_fee_received_data['bank_account_id']) && $share_fee_received_data['bank_account_id'] != 0){ ?>
								<option value="<?= $share_fee_received_data['bank_account_id']; ?>" selected>
									<?= isset($share_fee_received_data['bank_account_no']) ? $share_fee_received_data['bank_account_no'] : ''; ?>
								</option>
							<?php } ?>
						</select>
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="cheque_no">
						<?= lang('ShareFeeReceived.cheque_no');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="cheque_no" id="cheque_no"
							placeholder="Enter <?= lang('ShareFeeReceived.cheque_no');?>"
							value="<?= isset($share_fee_received_data['cheque_no']) ? $share_fee_received_data['cheque_no'] : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="amount">
						<?= lang('ShareFeeReceived.amount'); ?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="amount" id="amount"
							placeholder="Enter <?= lang('ShareFeeReceived.amount'); ?>"
							value="<?= isset($share_fee_received_data['amount']) ? $share_fee_received_data['amount'] : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="documents">Documents</label>
						<div class="col-sm-10 d-flex flex-wrap align-items-center" id="documents">
							<div class="form-check form-check-inline">
								<input type="checkbox" class="form-check-input" id="membership_form" name="membership_form" value="1" <?= isset($share_fee_received_data['membership_form']) && $share_fee_received_data['membership_form'] == 1 ? "checked" : '' ?>>
								<label class="form-check-label" for="membership_form">Membership Form</label>
							</div>
							<div class="form-check form-check-inline">
								<input type="checkbox" class="form-check-input" id="index_copy" name="index_copy" value="1" <?= isset($share_fee_received_data['index_copy']) && $share_fee_received_data['index_copy'] == 1 ? "checked" : '' ?>>
								<label class="form-check-label" for="index_copy">Index Copy</label>
							</div>
							<div class="form-check form-check-inline">
								<input type="checkbox" class="form-check-input" id="application_for_membership" name="application_for_membership" value="1" <?= isset($share_fee_received_data['application_for_membership']) && $share_fee_received_data['application_for_membership'] == 1 ? "checked" : '' ?>>
								<label class="form-check-label" for="application_for_membership">Application For Membership</label>
							</div>
							<div class="form-check form-check-inline">
								<input type="checkbox" class="form-check-input" id="photo" name="photo" value="1" <?= isset($share_fee_received_data['photo']) && $share_fee_received_data['photo'] == 1 ? "checked" : '' ?>>
								<label class="form-check-label" for="photo">Photo</label>
							</div>
							<div class="form-check form-check-inline">
								<input type="checkbox" class="form-check-input" id="pan_card" name="pan_card" value="1" <?= isset($share_fee_received_data['pan_card']) && $share_fee_received_data['pan_card'] == 1 ? "checked" : '' ?>>
								<label class="form-check-label" for="pan_card">PAN Card</label>
							</div>
							<div class="form-check form-check-inline">
								<input type="checkbox" class="form-check-input" id="adhar_card" name="adhar_card" value="1" <?= isset($share_fee_received_data['adhar_card']) && $share_fee_received_data['adhar_card'] == 1 ? "checked" : '' ?>>
								<label class="form-check-label" for="adhar_card">Aadhar Card</label>
							</div>
							<div class="form-check form-check-inline">
								<input type="checkbox" class="form-check-input" id="cheque" name="cheque" value="1" <?= isset($share_fee_received_data['cheque']) && $share_fee_received_data['cheque'] == 1 ? "checked" : '' ?>>
								<label class="form-check-label" for="cheque">Cheque</label>
							</div>
						</div>
				</div>

				<div class="pt-4">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('ShareFeeReceived'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
				</div>
			<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		flatDd();
		bankAccountDd();
		switcheryKeyGen("datatable-list-switchery");
		$("#receipt_date").flatpickr({
			dateFormat: 'd-m-Y'
		});
		
        // Initialize
		var validator = $("#form_share_fee_received").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				receipt_date : {
					required : true,
				},
				flat_id : {
					required : true,
				},
				bank_account_id : {
					required : true,
				},
				cheque_no : {
					required : true,
				},
				amount : {
					required : true,
				},
				
            },
            messages: {
				receipt_date: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('ShareFeeReceived.receipt_date');?>"
				},
				flat_id : {
					required : "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('ShareFeeReceived.flat_no');?>"
				},
				bank_account_id : {
					required : "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('ShareFeeReceived.bank_account_id');?>"
				},
				cheque_no : {
					required : "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('ShareFeeReceived.cheque_no');?>"
				},
				amount : {
					required : "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('ShareFeeReceived.amount');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("ShareFeeReceived/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {
                        //dtButtonShow('#submitBtn');
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
									dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('ShareFeeReceived');?>';
                                }
							});
						} else {
                            dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
						    toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});

						}
					}
				});
            }
        });
        
    });

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
