<?php
$assets = base_url() . 'assets/';
$societyData = !empty($society_data) && is_array($society_data) ? $society_data : array(); ?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?= $name; ?></title>
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
		  type="text/css">

	<link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
	<link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>
<style>
    table{
        padding: 3px !important;
    }
</style>
<body style="font-family: Helvetica, Arial, sans-serif; font-size: 13px;">

<?php
    // $shareCertificateData is the array you showed
    $sc   = isset($share_certificate_data) ? $share_certificate_data : [];
    $logo = isset($sc['logo']) && $sc['logo'] != ''
        ? base_url('uploads/society/' . $sc['logo'])   // adjust path to your logo folder
        : '';

    // small helpers
    $certificateNo   = $sc['certificate_no']          ?? '';
    $memberRegNo     = $sc['members_registration_no'] ?? '';
    $noOfShares      = $sc['no_of_shares']            ?? '';
    $holderName      = $sc['share_holder_name']       ?? '';
    $holderOf        = $sc['holder_of']               ?? '';
    $flatNo          = $sc['flat_no']                 ?? '';
    // $fromNo          = $sc['from_date']                 ?? '';   // if you store share range separately
    // $toNo            = $sc['to_date']                   ?? '';
    $fromDate        = !empty($sc['from_date'])       ? siteDateFormat($sc['from_date'])       : '';
    $toDate          = !empty($sc['to_date'])         ? siteDateFormat($sc['to_date'])         : '';
    $certificateDate = !empty($sc['certificate_date'])? siteDateFormat($sc['certificate_date']): '';

    $societyName     = $sc['society_name']     ?? '';
    $registrationNo  = $sc['registration_no']  ?? '';
    $sNo             = $sc['s_no']             ?? '';
    $tpNo            = $sc['tp_no']            ?? '';
    $fpNo            = $sc['fp_no']            ?? '';
    $opp            = $sc['opp']            ?? '';
    $area            = $sc['area']             ?? '';
    $taluka          = $sc['taluka']           ?? '';
    $district        = $sc['district']         ?? '';
    $state        = $sc['state']         ?? '';
    $postalAddress   = $sc['postal_address']   ?? '';
?>
<div style="width: 100%; border: 10px solid #375623; padding: 15px;">
    <table width="100%" cellspacing="0" cellpadding="8"
       style="border-collapse: collapse; line-height: 1.6;">

        <!-- Row 1: numbers -->
        <tr>
            <td align="center">Share Certificate No. <strong><?= esc($certificateNo); ?></strong></td>
            <td colspan="2" align="center">Member's Registration No. <strong><?= esc($memberRegNo); ?></strong></td>
            <td align="center">No. of Shares <strong><?= esc($noOfShares); ?></strong></td>
        </tr>

        <!-- Row 2–3: logo + titles -->
        <tr>
            <!-- Logo cell spans 2 rows -->
            <td rowspan="2" align="center" valign="middle" style="height: 110px; width: 22%;">
				<?php if ($logo) : ?>
					<img src="<?= $logo; ?>" style="max-height:90px; max-width:120px;">
                <?php else: ?>
                    LOGO
                <?php endif; ?>
            </td>
            <td colspan="3" align="center" style="font-size: 24px; font-weight: bold; color: #375623; letter-spacing: 1px;">
				SHARE CERTIFICATE
			</td>
        </tr>
		<tr>
			<td colspan="3" align="center" style="font-size: 18px; font-weight: bold; color: #375623;">
				<?= esc(strtoupper($societyName)); ?> CO-OP. HOUSING SERVICE SOCIETY LTD.
			</td>
		</tr>
        <!-- Row 4: Registration no -->
        <tr>
            <td colspan="4" align="center" style="font-size: 12px;">
                Registration No. <strong><?= esc($registrationNo); ?></strong>
            </td>
        </tr>

        <!-- Row 5: Act / address line -->
        <tr>
            <td colspan="4" style="font-size: 10px; text-align: center;">
                Registered under the <strong><?= esc($state); ?></strong> Co‑op. Societies Act, 1960<br>
                Revenue Survey No. <strong><?= esc($sNo); ?></strong> &nbsp;
                TP Scheme No. <strong><?= esc($tpNo); ?></strong> &nbsp;
                F P No. <strong><?= esc($fpNo); ?></strong> &nbsp;
                Opp. <strong><?= esc($opp); ?></strong> &nbsp;
                CITY <strong><?= esc($district); ?></strong>
            </td>
        </tr>

        <!-- Row 6: Main text -->
        <tr>
            <td colspan="4" style="text-align: justify; line-height: 1.8; padding-top: 12px; padding-bottom: 12px;">
                This is to certify that Mr. / Mrs. / M/s <strong><?= esc($holderName); ?></strong>,
                Flat No. <strong><?= esc($flatNo); ?></strong> is the registered holder of
                <strong><?= esc($holderOf); ?></strong>, fully paid up
                shares of Rs. 50/‑ (Fifty) each numbered from
                <strong><?= esc($fromDate); ?></strong> to <strong><?= esc($toDate); ?></strong>
                both inclusive, in <strong><?= esc($societyName); ?>, <?= esc($district); ?></strong>,
                subject to the Byelaws of the said Society.
            </td>
        </tr>

        <!-- Row 7: Date line -->
        <tr>
            <td colspan="4" style="padding-top: 12px; padding-bottom: 12px;">
                Given under the Common Seal of the said Society on this
                <strong><?= date('j', strtotime($certificateDate ?: date('Y-m-d'))); ?></strong>
                day of
                <strong><?= date('F, Y', strtotime($certificateDate ?: date('Y-m-d'))); ?></strong>
            </td>
        </tr>

        <!-- Row 8: Seal + three designations -->
		<tr style="height: 150px;">
			<!-- Seal -->
			<td width="25%" align="center" valign="middle">
				<div style="width: 120px; height: 80px; border-radius: 50%;
							background-color: #3d85c6; margin: 0 auto;"></div>
			</td>

			<!-- Authorised Committee Member -->
			<td width="25%" align="center" valign="bottom">
				<br>__________________ <br>
				Authorised Committee Member
			</td>

			<!-- Secretary -->
			<td width="25%" align="center" valign="bottom">
				<br>__________________ <br>
				Secretary
			</td>

			<!-- President -->
			<td width="25%" align="center" valign="bottom">
				<br>__________________ <br>
				President
			</td>
		</tr>

    </table>
</div>

<!-- Force new PDF page -->
<div style="page-break-before: always;"></div>

<!-- ===== Page 2: Memorandum of Transfers ===== -->
<div style="width: 100%; border: 0; padding: 8px;">
    <table width="100%" border="1"
           style="border-collapse: collapse; font-size: 11px; text-align: center;">

        <!-- Header row -->
        <tr>
            <th colspan="8" align="center"
                style="font-size: 14px; font-weight: bold;">
                MEMORANDUM OF TRANSFERS OF THE WITHIN MENTIONED SHARES
            </th>
        </tr>

        <!-- Column titles -->
        <tr style="font-weight: bold; text-align: center;">
            <td>Date of Transfer</td>
            <td>Transfer<br>No.</td>
            <td>Transferor<br>Registration No.</td>
            <td>To Whom<br>Transferred</td>
            <td>Transferee<br>Registration No.</td>
            <td>Authorized<br>Com. Member</td>
            <td>Secretary</td>
            <td>President</td>
        </tr>

        <!-- Empty rows for entries -->
        <?php for ($i = 0; $i < 15; $i++): ?>
            <tr>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
            </tr>
        <?php endfor; ?>

    </table>
</div>

</body>
</html>

