<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$isSuperAdmin = session('is_super_admin');
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('ShareCertificate.share_certificate_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_share_certificate',
				);
				echo form_open_multipart('',$form_id);
				$shareCertificateId = (isset($share_certificate_data['id']) && ($share_certificate_data['id'] != '')) ? $share_certificate_data['id'] : '';
				?>
				<input type="hidden" id="id" name="id" value="<?= $shareCertificateId ?>">

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="certificate_no">
						<?= lang('ShareCertificate.certificate_no');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="certificate_no" id="certificate_no"
							placeholder="Enter <?= lang('ShareCertificate.certificate_no');?>"
							value="<?= isset($share_certificate_data['certificate_no']) ? $share_certificate_data['certificate_no'] : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="members_registration_no">
						<?= lang('ShareCertificate.members_registration_no'); ?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="members_registration_no" id="members_registration_no"
							placeholder="Enter <?= lang('ShareCertificate.members_registration_no'); ?>"
							value="<?= isset($share_certificate_data['members_registration_no']) ? $share_certificate_data['members_registration_no'] : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="flat_id">
						<?= lang('ShareCertificate.flat_no');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<select id="flat_id" name="flat_id" class="select2 form-select flatDd" data-allow-clear="true">
							<option></option>
							<?php if(isset($share_certificate_data['flat_id']) && $share_certificate_data['flat_id'] != 0){ ?>
								<option value="<?= $share_certificate_data['flat_id']; ?>" selected>
									<?= isset($share_certificate_data['flat_no']) ? $share_certificate_data['flat_no'] : ''; ?>
								</option>
							<?php } ?>
						</select>
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="no_of_shares">
						<?= lang('ShareCertificate.no_of_shares');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control numberInit" name="no_of_shares" id="no_of_shares"
							placeholder="Enter <?= lang('ShareCertificate.no_of_shares');?>"
							value="<?= isset($share_certificate_data['no_of_shares']) ? $share_certificate_data['no_of_shares'] : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="share_holder_name">
						<?= lang('ShareCertificate.share_holder_name');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="share_holder_name" id="share_holder_name"
							placeholder="Enter <?= lang('ShareCertificate.share_holder_name');?>"
							value="<?= isset($share_certificate_data['share_holder_name']) ? $share_certificate_data['share_holder_name'] : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="holder_of">
						<?= lang('ShareCertificate.holder_of');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="holder_of" id="holder_of"
							placeholder="Enter <?= lang('ShareCertificate.holder_of');?>"
							value="<?= isset($share_certificate_data['holder_of']) ? $share_certificate_data['holder_of'] : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="from_date">
						<?= lang('ShareCertificate.from_date');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="from_date" id="from_date"
							placeholder="Select <?= lang('ShareCertificate.from_date');?>"
							value="<?= (isset($share_certificate_data['from_date']) && isValidDate($share_certificate_data['from_date']))
											? YMDToDMY($share_certificate_data['from_date']) : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="to_date">
						<?= lang('ShareCertificate.to_date');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="to_date" id="to_date"
							placeholder="Select <?= lang('ShareCertificate.to_date');?>"
							value="<?= (isset($share_certificate_data['to_date']) && isValidDate($share_certificate_data['to_date']))
											? YMDToDMY($share_certificate_data['to_date']) : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="certificate_date">
						<?= lang('ShareCertificate.certificate_date');?><span class="text-danger"> *</span>
					</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="certificate_date" id="certificate_date"
							placeholder="Select <?= lang('ShareCertificate.certificate_date');?>"
							value="<?= (isset($share_certificate_data['certificate_date']) && isValidDate($share_certificate_data['certificate_date']))
											? YMDToDMY($share_certificate_data['certificate_date']) : ''; ?>" />
					</div>
				</div>

				<div class="pt-4">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('ShareCertificate'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
				</div>
			<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		flatDd();
		switcheryKeyGen("datatable-list-switchery");
		var fromDateValue = $("#from_date").val();
		var toDatePicker = $("#to_date").flatpickr({
			dateFormat: 'd-m-Y',
			minDate: fromDateValue ? fromDateValue : null
		});
		$("#from_date").flatpickr({
			dateFormat: 'd-m-Y',
			onChange: function(selectedDates, dateStr, instance) {
				if (selectedDates.length > 0) {
					toDatePicker.set('minDate', selectedDates[0]);
				} else {
					toDatePicker.set('minDate', null);
				}
			}
		});
		$("#certificate_date").flatpickr({
			dateFormat: 'd-m-Y'
		});
        // Initialize
		var validator = $("#form_share_certificate").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				certificate_no : {
					required : true,
				},
				members_registration_no : {
					required : true,
				},
                flat_id: {
                    required: true,
                },
                no_of_shares : {
					required : true,
				},
                share_holder_name: {
                    required: true,
                },
                holder_of : {
					required : true,
				},
                from_date: {
                    required: true,
                },
                to_date : {
					required : true,
				},
                certificate_date: {
                    required: true,
                },
				
            },
            messages: {
				certificate_no: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('ShareCertificate.certificate_no');?>"
				},
				members_registration_no : {
					required : "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ShareCertificate.members_registration_no');?>"
				},
                flat_id: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ShareCertificate.flat_id');?>"
                },
                no_of_shares : {
					required : "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ShareCertificate.no_of_shares');?>"
				},
                share_holder_name: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ShareCertificate.share_holder_name');?>"
                },
                holder_of : {
					required : "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ShareCertificate.holder_of');?>"
				},
                from_date: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ShareCertificate.from_date');?>"
                },
                to_date : {
					required : "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ShareCertificate.to_date');?>"
				},
                certificate_date: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ShareCertificate.certificate_date');?>"
                },
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("ShareCertificate/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {
                        //dtButtonShow('#submitBtn');
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
									dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('ShareCertificate');?>';
                                }
							});
						} else {
                            dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
						    toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});

						}
					}
				});
            }
        });
        
    });

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
