<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
    <div class="card-datatable text-nowrap table-responsive">
        <table id="item_ledger_table" class="table dt-datatable dt-scrollableTable">
            <thead class="border-top">
            <tr>
                <th class="font-weight-bold"><?= lang("RsvpMeeting.rsvp_meeting_id"); ?></th>
                <th class="font-weight-bold"><?= lang("RsvpMeeting.meeting_title"); ?></th>
                <th class="font-weight-bold"><?= lang("RsvpMeeting.name"); ?></th>
                <th class="font-weight-bold"><?= lang("RsvpMeeting.status"); ?></th>
            </tr>
            </thead>
        </table>
    </div>
    <!--	</div>-->
</div>
<script type="text/javascript">
    var dt_DataTable;

    $(document).ready(function () {
        commonAreaDd();
        itemDd();
        financialYearDd();
        $('#filter_transaction_type').select2();
        dt_DataTable = $('#item_ledger_table').DataTable( {
            dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
                '<"me-5 ms-n2 pe-5"f>' +
                '<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
                '>t' +
                '<"row mx-2"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            processing: true,
            serverSide: true,
            displayLength: 10,
            scrollX: true,
            // language: {
            // 	sLengthMenu: 'Show _MENU_',
            // 	search: '',
            // 	searchPlaceholder: 'Search RsvpMeeting'
            // },
            language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search Meeting Consent',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },

            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
                    text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
                    buttons: [
                        {
                            text: '<i class="ti ti-file me-2" ></i>Excel',
                            className: 'dropdown-item dt-excel-export'
                        },
                        // {
                        // 	extend: 'pdf',
                        // 	text: '<i class="ti ti-file-text me-2"></i>Pdf',
                        // 	className: 'dropdown-item',
                        //
                        // }
                    ]
                },
            ],
            "ajax": {
                "url": "<?php echo admin_url('RsvpMeeting/getRsvpMeetingListing'); ?>",
                "type": "POST",
                "data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
            },
            "order": [[ 0, "desc" ]],
            "columns": [
                {"data": "rsvp_meeting_id" ,    visible: false,},
                {"data": "meeting_title"},
                {"data": "name"},
                {"data": "rsvp_status",
                    "render": function (data, type, row) {
                        var str = "";
                        var typeClass = "";
                        if(row['rsvp_status'] == 1){
                            typeClass = "success";
                            str = "Yes";
                        }else if (row['rsvp_status'] == -1){
                            typeClass = "danger";
                            str = "No";
                        }else if (row['rsvp_status'] == 0){
                            typeClass = "secondary";
                            str = "Pending";
                        }
                        return "<span class='badge bg-"+typeClass+"'>"+str+"</span>";
                    },
                },
            ],
            "fnDrawCallback": function (oSettings, json) {
                $('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
                $('.dt-buttons').addClass('d-flex flex-wrap');
                $('.dataTables_filter .form-control').removeClass('form-control-sm');
                $('.dataTables_length .form-select').removeClass('form-select-sm');
                customToolTip();
            }
        });
        dtDataTableSearch();

    });

    $(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});

    $(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #filter_common_area_id').val('').trigger('change');
		$('form#advanceFilter  #filter_financial_year_id').val('').trigger('change');
		$('form#advanceFilter  #filter_transaction_type').val('').trigger('change');
        $('form#advanceFilter  #filter_item_id').val('').trigger('change');
		dt_DataTable.draw();
	});

    $(document).on('click', '.dt-excel-export', function() {
        $(this).removeClass(".dt-excel-export");
        var dataTableParams = dt_DataTable.ajax.params();
        url = '<?= admin_url('RsvpMeeting/excelExportRsvpMeeting/') . ""  ?>';
        var recursiveEncoded = $.param(dataTableParams);
        $('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
        $('.dt-export-anchor')[0].click();
    });
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
