<!-- Add New Address Modal -->
<div class="modal fade" id="resource_type_modal" tabindex="-1" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-simple modal-add-new-address">
		<div class="modal-content p-3 p-md-5">
			<div class="modal-body">
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				<div class="text-center mb-4">
					<h3 class="address-title mb-2"><?= lang('ResourceType.resource_type_form'); ?></h3>
				</div>
				<?php
				$form_id = array(
					'id' => 'form_resource_type',
					'method' => 'post',
					'class' => 'row g-3',
					'autocomplete' => 'off'
				);
				echo form_open_multipart('',$form_id);
				?>
				<input type="hidden" name="resource_type_id" id="resource_type_id">
				<div class="col-12">
					<label class="form-label" for=""><?= lang('ResourceType.resource_type_name'); ?><span class="text-danger"> *</span></label>
					<input type="text" id="resource_type_name" name="resource_type_name" class="form-control" placeholder="Enter <?= lang('ResourceType.resource_type_name'); ?>"/>
				</div>

				<div class="col-12">

					<label class="switch switch-sm">
						<input type="checkbox" class="switch-input form-add-switchery "  name="is_login" id="is_login"/>
						<span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
						<span class="switch-label">Can Resource Type Login</span>
					</label>
				</div>

				<div class="col-12 dt-group">
					<label class="form-label" for=""><?= lang('ResourceType.group'); ?><span class="text-danger"> </span></label>
					<select id="group_id" name="group_id" class="select2 form-select groupDd" data-allow-clear="true">
					</select>
				</div>

				<div class="col-12">

					<label class="switch switch-sm">
						<input type="checkbox" class="switch-input form-add-switchery "  name="is_helper" id="is_helper"/>
						<span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
						<span class="switch-label">Is Helper</span>
					</label>
				</div>

				<div class="col-12">

					<label class="switch switch-sm">
						<input type="checkbox" class="switch-input form-add-switchery "  name="is_guard" id="is_guard"/>
						<span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
						<span class="switch-label">Is Guard</span>
					</label>
				</div>


				<div class="col-12">

					<label class="switch switch-sm">
						<input type="checkbox" class="switch-input form-add-switchery "  name="is_active" id="is_active"/>
						<span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
						<span class="switch-label">Active</span>
					</label>
				</div>
				<div class="col-12 text-center">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button
						type="reset"
						class="btn btn-label-secondary"
						data-bs-dismiss="modal"
						aria-label="Close">
						Cancel
					</button>
				</div>
				<?= form_close(); ?>
			</div>
		</div>
	</div>
</div>
<!--/ Add New Address Modal -->


<!--  add,update and delete model code here-->
<script type="text/javascript">
	//var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
	$(document).ready(function () {
		if ($("#is_login").is(':checked')) {
            $(".dt-group").show();
        }else{
            $(".dt-group").hide();
        }

        $("#is_login").change(function () {
            if ($(this).is(':checked')) {
                $(".dt-group").show();
            }else{
                $(".dt-group").hide();
            }
        });

		//societyDd();
		//customToolTip();
		//validation
		var validator = $("#form_resource_type").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function (label) {
				label.addClass('validation-valid-label'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function (error, element) {
				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				resource_type_name: {
					required: true
				}
			},
			messages: {
				resource_type_name: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ResourceType.resource_type_name'); ?>",
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("ResourceType/addEdit");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
					},
					complete: function () {
						//laddaStop();
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
                                    $('#resource_type_modal').modal('hide');
									dt_DataTable.ajax.reload(null,false);
                                }
							});
							// setTimeout(function () {
							// 	$('#resource_type_modal').modal('hide');
							// 	dt_DataTable.ajax.reload(null,false);
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
