<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$session       = \Config\Services::session();
$prefix = RENTAL_PREFIX;
$rentalsView = isset($rentals_data['view']) ? $rentals_data['view'] : 0;
$flatId = isset($rentals_data['flat_id']) ? $rentals_data['flat_id'] : 0 ;
?>
<!-- Multi Column with Form Separator -->
<div class="card mb-4">
	<h5 class="card-header"><?= lang('Rentals.rentals_form'); ?>
	<?php 
	$isClose = (isset($rentals_data['is_close']) && ($rentals_data['is_close'] != '')) ? $rentals_data['is_close'] : '';
	if($isClose == 1){ ?>
		<span class="badge bg-label-danger"><?= isset($rentals_data['status_name']) ? $rentals_data['status_name']: ''; ?></span>
	<?php } ?>
	</h5> 
		<?php
		//create  form open tag
		$form_id = array(
			'id'=>'form_rentals',
			'class'=>'card-body',
		);
		echo form_open_multipart('',$form_id);
		$rentalsId = (isset($rentals_data['rentals_id']) && ($rentals_data['rentals_id'] != '')) ? $rentals_data['rentals_id'] : '';
		?>
		<input type="hidden" id="rentals_id" name="rentals_id" value="<?= $rentalsId ?>">
        <input type="hidden" id="ownership_flat_id"  name="ownership_flat_id" class="ownership_flat_id" value="<?= isset($rentals_data['ownership_flat_id']) ? $rentals_data['ownership_flat_id'] : ""; ?>">
		<h6>1. <?= lang('Rentals.rentals_basic_information')?></h6>
		<div class="row g-3">


		<div class="col-md-3">
			<label class="form-label"><?= lang('Rentals.prefix'); ?></label>
			<input type="text" id="prefix" name="prefix" class="form-control customerWarehousePrefix" placeholder="Enter <?= lang('prefix'); ?>" value="<?= isset($rentals_data['prefix']) ? $rentals_data['prefix'] :  $prefix; ?>" readonly />
		</div>

		<div class="col-md-3">
			<label class="form-label"><?= lang('Rentals.series'); ?></label>
			<input type="text" id="series" name="series" class="form-control series" placeholder="Enter <?= lang('series'); ?>" value="<?= isset($rentals_data['series']) ? $rentals_data['series'] : ""; ?>" readonly />
		</div>

			<div class="col-md-6">
				<label class="form-label" ><?= lang('Rentals.flat'); ?><span class="text-danger"> *</span></label>&nbsp;  <button type="button" class="btn btn-label-primary dt-view_flat-detail btn btn-xs" > View Flat Detail </button>
<!--				<select id="flat_id" name="flat_id" class="select2 form-select flatDd dt-flat"  data-allow-clear="true">-->
				<select id="flat_id" name="flat_id" class="select2 form-select ownerflatDd dt-flat"  data-allow-clear="true">
					<option></option>
					<?php if(isset($rentals_data['flat_id']) && $rentals_data['flat_id'] != 0){ ?>
						<option value="<?= isset($rentals_data['flat_id']) ? $rentals_data['flat_id'] : 0 ?>" selected> <?= isset($rentals_data['flat_no']) ? $rentals_data['flat_no'] : ''  ?> </option>
					<?php } ?>
				</select>
			</div>

            <hr class="my-4 mx-n4" />
            <h6> <?= lang('Rentals.flat_owner_information'); ?></h6>
            <div class="row">
                <?= isset($rentals_flat_owner_table) ? $rentals_flat_owner_table : ""; ?>
            </div>
            <hr class="my-4 mx-n4" />
            <?php /*
			<div class="col-md-3">
				<label class="form-label" for="multicol-username"><?= lang('Rentals.resident'); ?></label>
				<input type="text" id="resident" name="resident" class="form-control" placeholder="Enter <?= lang('Rentals.resident'); ?>"  value="<?= isset($rentals_data['resident']) ? $rentals_data['resident'] : "Tenant"; ?>" readonly/>
			</div>
            */ ?>
            <?php /*
			<div class="col-md-6">
				<label class="form-label" ><?= lang('Rentals.owner_member'); ?><span class="text-danger"> *</span></label>
				<select id="owner_member_id" name="owner_member_id" class="select2 form-select ownershipFlatMemberDd"  data-allow-clear="true">
					<option></option>
					<?php if(isset($rentals_data['owner_member_id']) && $rentals_data['owner_member_id'] != 0){ ?>
						<option value="<?= isset($rentals_data['owner_member_id']) ? $rentals_data['owner_member_id'] : 0 ?>" selected> <?= isset($rentals_data['owner_member_name']) ? $rentals_data['owner_member_name'] : ''  ?> </option>
					<?php } ?>
				</select>
			</div>

			<div class="col-md-6">
				<label class="form-label" for="multicol-username"><?= lang('Rentals.owner_contact_no'); ?><span class="text-danger"> *</span></label>
				<input type="text" id="owner_contact_no" name="owner_contact_no" class="form-control" placeholder="Enter <?= lang('Rentals.owner_contact_no'); ?>" value="<?= isset($rentals_data['owner_contact_no']) ? $rentals_data['owner_contact_no'] : ""; ?>" readonly/>
			</div>
 */ ?>

			<div class="col-md-6">
				<label class="form-label" ><?= lang('Rentals.broker'); ?><span class="text-danger"> *</span></label>
				<select id="broker_id" name="broker_id" class="select2 form-select brokerDd"  data-allow-clear="true">
					<option></option>
					<?php if(isset($rentals_data['broker_id']) && $rentals_data['broker_id'] != 0){ ?>
						<option value="<?= isset($rentals_data['broker_id']) ? $rentals_data['broker_id'] : 0 ?>" selected> <?= isset($rentals_data['broker_name']) ? $rentals_data['broker_name'] : ''  ?> </option>
					<?php } ?>
				</select>
			</div>

			<div class="col-md-6">
				<label class="form-label" for="multicol-username"><?= lang('Rentals.broker_contact_no'); ?><span class="text-danger"> *</span></label>
				<input type="text" id="broker_contact_no" name="broker_contact_no" class="form-control" placeholder="Enter <?= lang('Rentals.broker_contact_no'); ?>" value="<?= isset($rentals_data['broker_contact_no']) ? $rentals_data['broker_contact_no'] : ""; ?>" readonly/>
			</div>

			<div class="col-md-4">
				<label class="form-label" for="multicol-username"><?= lang('Rentals.tenant_name'); ?><span class="text-danger"> *</span></label>
				<input type="text" id="tenant_name" name="tenant_name" class="form-control" placeholder="Enter <?= lang('Rentals.tenant_name'); ?>" value="<?= isset($rentals_data['tenant_name']) ? $rentals_data['tenant_name'] : ""; ?>" />
			</div>

			<div class="col-md-4">
				<label class="form-label" for="multicol-username"><?= lang('Rentals.tenant_contact_no'); ?><span class="text-danger"> *</span></label>
				<input type="text" id="tenant_contact_no" name="tenant_contact_no" class="form-control numberInit" placeholder="Enter <?= lang('Rentals.tenant_contact_no'); ?>" value="<?= isset($rentals_data['tenant_contact_no']) ? $rentals_data['tenant_contact_no'] : ""; ?>" />
			</div>

			<div class="col-md-4">
				<label class="form-label" for="multicol-username"><?= lang('Rentals.tenant_email'); ?></label>
				<input type="email" id="tenant_email" name="tenant_email" class="form-control" placeholder="Enter <?= lang('Rentals.tenant_email'); ?>" value="<?= isset($rentals_data['tenant_email']) ? $rentals_data['tenant_email'] : ""; ?>" />
			</div>

			<div class="col-md-6">
				<label class="form-label" for="basic-default-name"><?= lang('Rentals.rent_agreement_period_from');?><span class="text-danger"> *</span></label>
				<input type="text" class="form-control" name="rent_agreement_period_from" id="rent_agreement_period_from" placeholder="Select <?= lang('Rentals.rent_agreement_period_from');?>" value="<?= (isset($rentals_data['rent_agreement_period_from']) && isValidDate($rentals_data['rent_agreement_period_from'])) ? siteDateFormat($rentals_data['rent_agreement_period_from']) : ''; ?>"
				<?php if($rentalsId != ''){ ?>
					<?= (!($dtCIAcl->checkAccess('Rentals|editDate'))) ? 'readonly': '' ?>
				<?php } ?>
				/>
			</div>

			<div class="col-md-6">
				<label class="form-label" for="basic-default-name"><?= lang('Rentals.rent_agreement_period_to');?><span class="text-danger"> *</span></label>
				<input type="text" class="form-control" name="rent_agreement_period_to" id="rent_agreement_period_to" placeholder="Select <?= lang('Rentals.rent_agreement_period_to');?>" value="<?= (isset($rentals_data['rent_agreement_period_to']) && isValidDate($rentals_data['rent_agreement_period_to'])) ? siteDateFormat($rentals_data['rent_agreement_period_to']) : ''; ?>"
				<?php if($rentalsId != ''){ ?>
					<?= (!($dtCIAcl->checkAccess('Rentals|editDate'))) ? 'readonly': '' ?>
				<?php } ?>
				/>
			</div>			

			<div class="col-md-6">
				<label class="form-label" for="multicol-username"><?= lang('Rentals.permanent_address'); ?><span class="text-danger"> *</span></label>
				<textarea name="permanent_address"  id="permanent_address" placeholder="Enter <?= lang('Rentals.permanent_address'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($rentals_data['permanent_address']) && ($rentals_data['permanent_address'] != '')) ? $rentals_data['permanent_address'] : ''; ?></textarea>
			</div>

			<div class="col-md-6">
				<label class="form-label" for="multicol-username"><?= lang('Rentals.work_address'); ?><span class="text-danger"> *</span></label>
				<textarea name="work_address"  id="work_address" placeholder="Enter <?= lang('Rentals.work_address'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($rentals_data['work_address']) && ($rentals_data['work_address'] != '')) ? $rentals_data['work_address'] : ''; ?></textarea>
			</div>

            <?php /*
			<div class="col-md-2">
				<label class="form-label" for="multicol-username"><?= lang('CommonMessage.common_active'); ?></label>
				<label class="switch switch-sm"><span class="switch-label"></span>
					<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php if(isset($rentals_data['is_active']) && $rentals_data['is_active'] == 1) {  echo 'checked="checked"'; } else { echo ''; } ?>/>
					<span class="switch-toggle-slider">
						  <span class="switch-on"></span>
						  <span class="switch-off"></span>
					</span>
				</label>
			</div> */ ?>


		</div>
		<hr class="my-4 mx-n4" />

		<h6>2. <?= lang('Rentals.member_information'); ?></h6>
		<div class="row g-3">
			<?= isset($rentals_member_table) ? $rentals_member_table : ""; ?>
		</div>
		<?php if ($dtCIAcl->checkAccess('Rentals|manage')) { ?>
			<button type="button" class="btn btn-xs btn-primary" onclick="addRentalsMember()">
				<i class="ti ti-plus me-1"></i>
				<span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
			</button>
		<?php } ?>

	<hr class="my-4 mx-n4" />
	<h6>3. <?= lang('Rentals.emergency_information'); ?></h6>
	<div class="row g-3">
		<?= isset($rentals_emergency_contact_table) ? $rentals_emergency_contact_table : ""; ?>
	</div>
	<?php if ($dtCIAcl->checkAccess('Rentals|manage')) { ?>
		<button type="button" class="btn btn-xs btn-primary" onclick="addRentalsEmergencyContact()">
			<i class="ti ti-plus me-1"></i>
			<span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
		</button>
	<?php } ?>

	<hr class="my-4 mx-n4" />
	<h6>4. <?= lang('Rentals.parking_information'); ?></h6>
	<div class="row g-3">
		<?= isset($rentals_parking_table) ? $rentals_parking_table : ""; ?>
	</div>
	<?php if ($dtCIAcl->checkAccess('Rentals|manage')) { ?>
		<button type="button" class="btn btn-xs btn-primary" onclick="addRentalsParking()">
			<i class="ti ti-plus me-1"></i>
			<span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
		</button>
	<?php } ?>

	<?php /*
    <hr class="my-4 mx-n4" />
    <h6>5. <?= lang('Rentals.access_card_information'); ?></h6>
    <div class="row g-3">
        <?= isset($rentals_access_card_table) ? $rentals_access_card_table : ""; ?>
    </div>
    <?php if ($dtCIAcl->checkAccess('Rentals|manage')) { ?>
        <button type="button" class="btn btn-xs btn-primary" onclick="addRentalsAccessCard()">
            <i class="ti ti-plus me-1"></i>
            <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
        </button>
    <?php } ?> */ ?>

	<hr class="my-4 mx-n4" />
	<h6>5. <?= lang('Rentals.rentals_document'); ?></h6>
	<div class="row g-3">
		<?= isset($document_table) ? $document_table : ""; ?>
	</div>

	<?php if($rentalsView != 1) { ?>

	<div class="pt-4">
		<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
		<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Rentals'); ?>'" class="btn btn-label-secondary"><?= lang('CommonMessage.common_cancel'); ?></button>
	</div>
	<?php } ?>
	<?php echo form_close(); ?>
</div>

<script>

	var editable = <?= $rentalsView ?>;
    if(editable == 1)
    {
        $("#form_rentals :input").prop("disabled", true);
        $(".dt-delete-member-row").removeAttr("onclick");
        $(".dt-delete-member-row").remove();
        $(".dt-delete-emergency-contact-row").removeAttr("onclick");
        $(".dt-delete-emergency-contact-row").remove();
        $(".dt-delete-parking-row").removeAttr("onclick");
        $(".dt-delete-parking-row").remove();
        $(".dt-delete-access-card-row").removeAttr("onclick");
        $(".dt-delete-access-card-row").remove();
        $(".module-delete-image").removeAttr("onclick");
        $(".module-delete-image").remove();

    }

	function rentalsMember() {
		addValidation("input", ".dt-name", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_enter');?> "+"<?= lang('Rentals.name');?>",
			}
		});
		//addValidation("input", ".dt-mobile-no", {
		//	required: true,
		//	minlength: 10,
		//	maxlength: 10,
		//	messages: {
		//		required: "<?php //= lang('CommonMessage.common_please_enter');?>// "+"<?php //= lang('Rentals.mobile');?>//",
		//	}
		//});

		addValidation("input", ".dt-relation", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_select');?> "+"<?= lang('Rentals.relation');?>",
			}
		});

		addValidation("input", ".dt-gender", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_select');?> "+"<?= lang('Rentals.gender');?>",
			}
		});

		addValidation("input", ".dt-birth-date", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_select');?> "+"<?= lang('Rentals.birth_yr');?>",
			}
		});
		

	}

	function emergencyContact() {
		addValidation("input", ".dt-ecname", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_enter');?> "+"<?= lang('Rentals.e_name');?>",
			}
		});
		addValidation("input", ".dt-ecplace", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_select');?> "+"<?= lang('Rentals.e_place');?>",
			}
		});

		addValidation("input", ".dt-ecrelation", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_enter');?> "+"<?= lang('Rentals.e_relation');?>",
			}
		});

		addValidation("input", ".dt-ecmobile-no", {
			required: true,
			minlength: 10,
			maxlength: 10,
			messages: {
				required: "<?= lang('CommonMessage.common_please_enter');?> "+"<?= lang('Rentals.e_mobile');?>",
			}
		});
	}


	function rentalsParking() {
	
		addValidation("select", ".dt-vehicle-type", {
			required: true,
			messages: {
				required: "<?= lang('CommonMessage.common_please_select');?> "+"<?= lang('Rentals.vehicle_type');?>",
			}
		});

		// addValidation("select", ".parking-place-id", {
		// 	required: true,
		// 	messages: {
		// 		required: "<?= lang('CommonMessage.common_please_select');?> "+"<?= lang('Rentals.parking_place');?>",
		// 	}
		// });

		// addValidation("input", ".dt-vehicle-no", {
		// 	required: true,
		// 	messages: {
		// 		required: "Please Enter "+"<?= lang('Rentals.vehicle_no');?>",
		// 	}
		// });
	
	}


	let agreementPeriodFrom;
	let agreementPeriodTo;

	function fromAndToPeriod(){
		var agreementPeriodFrom = $("#rent_agreement_period_from").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y',
			onChange: function( selectedDates, dateStr, instance ) {
				agreementPeriodTo.set('minDate', dateStr)
			}
		});

		var agreementPeriodTo = $("#rent_agreement_period_to").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y',
		});
	}

	$(document).ready(function() {
		//societyDd();
		//towerDd();
		// flatDd();
        ownerflatDd();
		parkingSlotDd();
		//ownershipFlatMemberDd();
		$('.dt-is-electric').select2();
		numberInit();
		brokerDd();
        amenitiesDd();
		addSerialNumber('rentals_member_table');
		addSerialNumber('rentals_emergency_contact_table');
		addSerialNumber('rentals_parking_table');
		addSerialNumber('document_table');
        addSerialNumber('rentals_flat_owner_table');
        addSerialNumber('rentals_access_card_table');
		$('.dt-food-like').select2();
		$('.document-type').select2();
		$('.dt-blood-group').select2();
		$('.dt-relation,.dt-ecrelation').select2();
        $('.dt-access-card-vehicle-type').select2();

		<?php if (!isset($rentals_data['rentals_id'])){ ?>
			getRentalPrefix();
		<?php } ?>
		<?php 
		if(($dtCIAcl->checkAccess('Rentals|editDate'))) { ?>
			fromAndToPeriod();
		<?php } else { 
			if($rentalsId == ''){
			?>
			fromAndToPeriod();
			<?php } } ?>
		dateInit();
		dateDocumentInit();

        <?php if($rentalsId != ''){ ?>
        $(".dt-view_flat-detail").addClass('dt-detail-model-view');
        $(".dt-view_flat-detail").attr('data-dt_view_id', '<?= $flatId; ?>');
        $(".dt-view_flat-detail").attr('data-dt_view_url', '<?= admin_url("Flat/view"); ?>');
        <?php  } ?>
		// Initialize
		var validator = $("#form_rentals").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				// society_id: {
				// 	required: true,
				// },
				// tower_id: {
				// 	required: true,
				// },
				flat_id: {
					required: true,
				},
                <?php /*
				owner_member_id : {
					required : true,
				},
				owner_contact_no : {
					required : true,
				},
                */ ?>
				broker_id : {
					required : true,
				},
				broker_contact_no :{
					required : true,
				},
				tenant_name : {
					required : true,
				},
				tenant_contact_no : {
					required : true,
					minlength: 10,
					maxlength: 10,
				},
				// tenant_email : {
				// 	required : true,
				// },
				permanent_address :{
					required : true,
				},
				work_address :{
					required : true,
				},
				rent_agreement_period_from :{
					required : true,
				},
				rent_agreement_period_to :{
					required : true,
				},
			},
			messages: {
				//society_id: {
				//	required: '<?php //= lang("common_please_select"); ?>// <?php //= lang("society"); ?>//.'
				//},
				//tower_id: {
				//	required: '<?php //= lang("common_please_select"); ?>// <?php //= lang("tower"); ?>//.'
				//},
				flat_id: {
					required: '<?= lang('CommonMessage.common_please_select'); ?> <?= lang("Rentals.flat"); ?>',
				},
               
				// owner_member_id : {
				// 	required: "<?= lang('CommonMessage.common_please_select'); ?>  <?= lang("Rentals.owner_member"); ?>",
				// },
				// owner_contact_no : {
				// 	required: '<?= lang('CommonMessage.common_please_enter'); ?>  <?= lang("Rentals.owner_contact_no"); ?>',
				// },
              
				broker_id : {
					required: "<?= lang('CommonMessage.common_please_select'); ?>  <?= lang("Rentals.broker"); ?>",
				},
				broker_contact_no :{
					required: '<?= lang('CommonMessage.common_please_enter'); ?>  <?= lang("Rentals.broker_contact_no"); ?>',
				},
				tenant_name : {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Rentals.tenant_name"); ?>',
				},
				tenant_contact_no : {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Rentals.tenant_contact_no"); ?>',
				},
				// tenant_email : {
				// 	required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Rentals.tenant_email"); ?>',
				// },
				permanent_address :{
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Rentals.permanent_address"); ?>',
				},
				work_address :{
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Rentals.work_address"); ?>',
				},
				rent_agreement_period_from :{
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Rentals.rent_agreement_period_from"); ?>',
				},
				rent_agreement_period_to :{
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Rentals.rent_agreement_period_to"); ?>',
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Rentals/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Rentals');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Rentals');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});

		// $("#date_of_registry").datepicker({
		// 	todayHighlight: true,
		// 	format: 'dd-mm-yyyy',
		// 	orientation: isRtl ? 'auto right' : 'auto left'
		// });
		rentalsMember();
		emergencyContact();
		rentalsParking();
	});

	 function getRentalPrefix(prefix = '') {
		var tableType = "rentals";
		var societyId = "<?= $session->get('society_id') ?>";
		if (prefix != '') {
			var displayPrefix = prefix;
		} else {
			var displayPrefix = "<?= $prefix ?>";
		}
		getNextSeriesJS(tableType, displayPrefix, societyId);
	}

	$(document).on('click', '.module-delete-image', function () {
    	var deleteId = $(this).attr("id");
		var rentalsId = $("#rentals_id").val();
    	Swal.fire({
			title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
			text: "<?= lang('CommonMessage.delete_warning'); ?>",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'OK',
			customClass: {
				confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
				cancelButton: 'btn btn-label-secondary waves-effect waves-light'
			},
			buttonsStyling: false
		}).then(function(result) {
			if (result.value) {
		        $("span.document-remove-image-"+deleteId).remove();
		        $.ajax({
		            type: "post",
		            url: "<?= admin_url("Staff/deleteModuleImage")?>",
		            dataType: "json",
		            data: {module_document_image_id: deleteId,module:"rentals",module_id:rentalsId},
		            success: function (data) {
		                if (data['success']) {
		                    Swal.fire({
								title: 'Success',
								text: data['msg'],
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		                else{
		                    Swal.fire({
								title: 'Error!',
								text: data['msg'],
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		            }
		        });
		    }
		});
    });

    //$(document).on('click', '.dt-view_flat-detail', function() {
	//	var flatId = $("#flat_id").val();
	//	$.ajax({
	//		type: "post",
	//		url: '<?php //echo admin_url("OwnershipFlat/flatData");?>//',
	//		dataType: "json",
	//		async: false,
	//		data: {
	//			flat_id: flatId,
	//		},
	//		success: function(data) {
	//			if (data) {
	//				if (data.success) {
	//					$("#view_model_flat_item").html(data.flat_modal_data);
	//					$('#flat_detail').modal('show');
	//				}
	//				else {
	//					Swal.fire({
	//						title: 'Error!',
	//						text: data.msg,
	//						icon: 'error',
	//						customClass: {
	//							confirmButton: 'btn btn-primary waves-effect waves-light'
	//						},
	//						buttonsStyling: false
	//					});
	//				}
	//			}
	//		}
	//	});
	//});

    $(document).on('click', '.dt-agreement-with', function () {
        $('.dt-agreement-with').prop('checked', false);
        $(this).prop('checked', true);
    });
    $(document).on('change', '#flat_id', function () {
        var flatId    	= $(this).val();
        $.ajax({
            type: "POST",
            url: "<?php echo admin_url('Rentals/getFlatOwnerTableRow'); ?>",
            dataType: "json",
            data: {
                flat_id : flatId,
            },
            delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
            beforeSend: function (formData, jqForm, options) {
            },
            complete: function () {
            },
            success: function (resObj) {
                if (resObj.success) {
                    $('#rentals_flat_owner_table tbody').html(resObj.member_row_data);
                    addSerialNumber('rentals_flat_owner_table');
                } else {
                    console.log("ELSE");
                    console.log(resObj);
                    $('#rentals_flat_owner_table tbody').html(resObj.member_row_data);
                    addSerialNumber('rentals_flat_owner_table');
                }
            }
        });
    });
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
<div id="view_model_flat_item">

</div>

