<div class="modal fade" id="rental_change_status_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
        <div class="modal-content p-3 p-md-5">
            <div class="modal-body">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="text-center mb-4">
                    <h3 class="mb-2"><?= lang('Rentals.rental_close_agreement')?></h3>
                </div>

                <?php
                $form_id = array(
                    'id'        => 'form_rental_change_status_modal',
                    'method'    => 'post',
                    'class'     => 'row g-3',
                    'autocomplete' => 'off'
                ); ?>
                <?= form_open('', $form_id); ?>

                <input type="hidden" name="modal_rental_id" id="modal_rental_id">

                <div class="col-12">
                    <label class="form-label w-100" for="modalAddCard"><?= lang('Rentals.closing_date'); ?></label>
                    <div class="input-group input-group-merge">
                        <input type="text" class="form-control" name="closing_date" id="closing_date" placeholder="Select <?= lang('Rentals.closing_date'); ?>" />
                    </div>
                </div>
                <div class="col-12">
                    <label class="form-label" for="modalAddCardName"><?= lang('Rentals.closing_reason'); ?></label>
                    <textarea name="closing_reason" id="closing_reason" placeholder="Enter <?= lang('Rentals.closing_reason'); ?>" rows="3" cols="5" class="form-control"></textarea>
                </div>


                <div class="col-12 text-center">
                    <button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1"> <?= lang('CommonMessage.common_action'); ?></button>
                    <button type="reset" id="cancelBtn" class="btn btn-label-secondary btn-reset" data-bs-dismiss="modal" aria-label="Close">
                        <?= lang('CommonMessage.common_cancel'); ?>
                    </button>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>
<script>
    let closingDate;
    function closingDateInit() {
        var closingDate = $("#closing_date").flatpickr({
            dateFormat: 'd-m-Y'
        });
    }

    $(document).ready(function() {
		flatDd();
		brokerDd();
		statusDd();
		ownershipFlatMemberDd();
		closingDateInit();
		// Initialize
		var validator = $("#form_rental_change_status_modal").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				closing_date: {
					required: true,
				},
				closing_reason : {
					required : true,
				}
			},
			messages: {
				closing_date: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Rentals.closing_date"); ?>',
				},
				closing_reason : {
					required: "<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Rentals.closing_reason"); ?>",
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Rentals/changeRentalStatus");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {	
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							
                            $('#rental_change_status_modal').modal('hide');
							Swal.fire({
								title: 'Success',
								text: resObj.msg,
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								window.location.href = '<?php echo admin_url('Rentals');?>';
							});

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							Swal.fire({
								title: 'Error!',
								text: resObj.msg,
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							});
						}
					}
				});
			}
		});

		
	});

</script>