<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#poll_detail" aria-controls="poll_detail" aria-selected="true">
			<?= lang('Poll.poll_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#option_information" aria-controls="option_information" aria-selected="false">
			<?= lang('Poll.option_detail'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="poll_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="poll_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Poll.question"); ?></td>
						<td><?php
							echo (isset($poll_data['poll_title']) && $poll_data['poll_title'] != "") ? $poll_data['poll_title'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Poll.start_date"); ?></td>
						<td><?php
							echo (isValidDate($poll_data['start_date']) && $poll_data['start_date'] != "") ? siteDateFormat($poll_data['start_date']) : '-';
							?>
						</td>
					</tr>										
					<tr>
						<td><?= lang("Poll.end_date"); ?></td>
						<td><?php
							echo (isValidDate($poll_data['end_date']) && $poll_data['end_date'] != "") ? siteDateFormat($poll_data['end_date']) : '-';
							?>
						</td>
					</tr>										
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($poll_data['created_at']) && isValidDate($poll_data['created_at'])) ? siteDateFormat($poll_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($poll_data['created_by']) && $poll_data['created_by'] != "") ? $poll_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($poll_data['updated_at']) && isValidDate($poll_data['updated_at'])) ? siteDateFormat($poll_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($poll_data['updated_by']) && $poll_data['updated_by'] != "") ? $poll_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>

	<div class="tab-pane fade" id="option_information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="option_information" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang("Poll.option"); ?></th>
						<th><?= lang("Poll.sort_order"); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($poll_option_data != '' && array_filter($poll_option_data)) { ?>
						<?php
						$sr = 1;
						foreach ($poll_option_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td><?= $value['poll_option']; ?> </td>
								<td><?= $value['sort_order']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="4" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div>
</div>