<!-- Add New Address Modal -->
<div class="modal fade" id="parking_slot_modal" tabindex="-1" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-simple modal-add-new-address">
		<div class="modal-content p-3 p-md-5">
			<div class="modal-body">
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				<div class="text-center mb-4">
					<h3 class="address-title mb-2"><?= lang('ParkingSlot.parking_slot_form'); ?></h3>
				</div>
				<?php
				$form_id = array(
					'id' => 'form_parking_slot',
					'method' => 'post',
					'class' => 'row g-3',
					'autocomplete' => 'off'
				);
				echo form_open_multipart('',$form_id);
				?>
				<input type="hidden" name="parking_slot_id" id="parking_slot_id">
				<input type="hidden" name="parking_area_id" id="parking_area_id" class="dt-parking-area-id">
				<input type="hidden" name="vehicle_type" id="vehicle_type" class="dt-vehicle-type">

                <div class="col-12">
                    <label class="form-label" for=""><?= lang('ParkingSlot.parking_area'); ?><span class="text-danger"> *</span></label>
                    <select id="parking_vehicle_id" name="parking_vehicle_id" class="select2 form-select parkingVehicleDd" data-allow-clear="true">
                    </select>
                </div>

                <div class="col-12">
                    <label class="switch switch-sm">
                        <input type="checkbox" class="switch-input form-add-switchery "  name="is_visitor_parking" id="is_visitor_parking"/>
                        <span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
                        <span class="switch-label"><?= lang('ParkingSlot.is_visitor_parking')?></span>
                    </label>
                </div>

				<div class="col-12">
					<label class="form-label" for=""><?= lang('ParkingSlot.flat_no'); ?><span class="text-danger"> </span></label>
					<select id="flat_id" name="flat_id" class="select2 form-select flatDd" data-allow-clear="true">
					</select>
				</div>

				<div class="col-12">
					<label class="form-label" for=""><?= lang('ParkingSlot.number'); ?><span class="text-danger"> *</span></label>
					<input type="text" id="number" name="number" class="form-control" slotholder="Enter <?= lang('ParkingSlot.number'); ?>"/>
				</div>

				<div class="col-12">
					<label class="form-label" for=""><?= lang('ParkingSlot.vehicle'); ?><span class="text-danger"> </span></label>
					<select id="ownership_flat_parking_id" name="ownership_flat_parking_id" class="select2 form-select ownershipFlatVehicleDd" data-allow-clear="true">
					</select>
				</div>

				<div class="col-12">
					<label class="switch switch-sm">
						<input type="checkbox" class="switch-input form-add-switchery "  name="is_active" id="is_active"/>
						<span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
						<span class="switch-label">Active</span>
					</label>
				</div>
				<div class="col-12 text-center">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button
						id="cancelBtn"
						type="reset"
						class="btn btn-label-secondary"
						data-bs-dismiss="modal"
						aria-label="Close">
						Cancel
					</button>
				</div>
				<?= form_close(); ?>
			</div>
		</div>
	</div>
</div>
<!--/ Add New Address Modal -->


<!--  add,update and delete model code here-->
<script type="text/javascript">
	//var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
	$(document).ready(function () {
		// areaDd();
		var validator = $("#form_parking_slot").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function (label) {
				label.addClass('validation-valid-label'); // remove to hide Success message
			},
			// Different components require proper error label slotment
			errorSlotment: function (error, element) {
				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				parking_area_id: {
					required: true
				},
				number : {
					required: true
				},
				// flat_id : {
				// 	required: true
				// },
			},
			messages: {
				parking_area_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('ParkingSlot.parking_area'); ?>",
				},
				number : {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('ParkingSlot.number'); ?>",
				},
				//flat_id : {
				//	required: "<?php //= lang('CommonMessage.common_please_select'); ?>// <?php //= lang('ParkingSlot.vehicle'); ?>//",
				//},
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("ParkingSlot/addEdit");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {
						//laddaStop();
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    $('#parking_slot_modal').modal('hide');
									dt_DataTable.ajax.reload(null,false);
                                }
							});
							// setTimeout(function () {
							// 	$('#parking_slot_modal').modal('hide');
							// 	dt_DataTable.ajax.reload(null,false);
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>