<?php
$html = '';
if (isset($parking_vehicle_data) && !empty($parking_vehicle_data)) {
	foreach ($parking_vehicle_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["parking_vehicle_data"] = $value;
		$html .= view('Admin/ParkingArea/ParkingVehicleTableRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="parking_vehicle_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th style="width: 1%"><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th style="width: 10%"><?= lang('ParkingArea.vehicle_type'); ?><span class="text-danger"> *</span></th>
				<th style="width: 10%"><?= lang('ParkingArea.slot'); ?><span class="text-danger"> *</span></th>
				<th style="width: 10%"><?= lang('ParkingArea.number_type'); ?><span class="text-danger"> *</span></th>
				<th class="dt-range-label" style="width: 10%"><?= lang('ParkingArea.range_label'); ?><span class="text-danger"> *</span></th>
				<th class="dt-range-start-from" style="width: 10%"><?= lang('ParkingArea.range_start_from'); ?><span class="text-danger"> *</span></th>
				<th style="width: 10%"><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($parking_vehicle_data) && !empty($parking_vehicle_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/ParkingArea/ParkingVehicleTableRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addParkingVehicle() {
		var lastIndex = ($("#parking_vehicle_table tbody tr:last").length >= 1) ? $("#parking_vehicle_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('ParkingArea/addParkingVehicleRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#parking_vehicle_table tbody').append(data);
					addSerialNumber('parking_vehicle_table');
					$(".dt-number-type").select2();
					$(".dt-vehicle-type").select2();
					numberInit();
					customToolTip();
				}
			}
		});
		$('.dt-number-type').trigger('change');
		// towerUnitValidation();
	}


	$(document).on('click', '.dt-delete-unit-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".parking_vehicle_id").val();
		var parkingAreaId = $("#parking_area_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('ParkingArea/deleteParkingVehicleRow');?>",
						dataType: "json",
						async:false,
						data: {
                            parking_vehicle_id: deleteId,
                            parking_area_id: parkingAreaId
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('parking_vehicle_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#parking_vehicle_table tbody > tr').length == 0) {
                                        addParkingVehicle();
									}
								});
							} else {
								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('parking_vehicle_table');
			if ($('#parking_vehicle_table tbody > tr').length == 0) {
                addParkingVehicle();
			}
		}
	});


</script>
