<style>
	.form-controls {
		display: block;
		padding: 0.422rem 0.875rem;
		font-size: 0.9375rem;
		font-weight: 400;
		line-height: 1.5;
		color: #6f6b7d;
		appearance: none;
		background-color: #fff;
		background-clip: padding-box;
		border: var(--bs-border-width) solid #dbdade;
		border-radius: var(--bs-border-radius);
		transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
	}
</style>

<?php
$html = '';
$type = $request->getPost('type');

if (isset($ownership_flat_member_data) && !empty($ownership_flat_member_data)) {
	foreach ($ownership_flat_member_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["ownership_flat_member_data"] = $value;
		$html .= view('Admin/OwnershipFlat/OwnershipFlatMemberRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="ownership_flat_member_table" class="table">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('OwnershipFlat.mobile'); ?><span class="text-danger"> </span></th>
				<th><?= lang('OwnershipFlat.name'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('OwnershipFlat.email_id'); ?></th>
				<th><?= lang('OwnershipFlat.gender'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('OwnershipFlat.relation'); ?></th>
				<th><?= lang('OwnershipFlat.birth_yr'); ?><span class="text-danger"> </span></th>
				<th><?= lang('OwnershipFlat.blood_gp'); ?></th>
				<!-- <th><?//= lang('OwnershipFlat.food_like'); ?></th> -->
				<th><?= lang('OwnershipFlat.is_owner'); ?></th>
				<th><?= lang('OwnershipFlat.member_image'); ?></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($ownership_flat_member_data) && !empty($ownership_flat_member_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/OwnershipFlat/OwnershipFlatMemberRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;
	function dateInit(){
		$(".dt-birth-date").flatpickr({
			// monthSelectorType: 'static',
			dateFormat: 'd-m-Y'
		});
	}
	function addOwnershipFlatMember() {
		var lastIndex = ($("#ownership_flat_member_table tbody tr:last").length >= 1) ? $("#ownership_flat_member_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('OwnershipFlat/addOwnershipFlatMemberRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#ownership_flat_member_table tbody').append(data);
					addSerialNumber('ownership_flat_member_table');
					$('.dt-food-like').select2();
					dateInit();
					numberInit();
					ownerMember();
					customToolTip();
					$('.dt-relation,.dt-blood-group').select2();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-member-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".ownership_flat_member_id").val();
		var ownershipFlatId = $("#ownership_flat_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('OwnershipFlat/deleteOwnershipFlatMemberRow');?>",
						dataType: "json",
						async:false,
						data: {
							ownership_flat_member_id: deleteId,
							ownership_flat_id: ownershipFlatId,
							type : '<?= $type;?>'
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('ownership_flat_member_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#ownership_flat_member_table tbody > tr').length == 0) {
										addOwnershipFlatMember();
									}
								});
							} else {
								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('ownership_flat_member_table');
			if ($('#ownership_flat_member_table tbody > tr').length == 0) {
				addOwnershipFlatMember();
			}
		}
	});

	$(document).on('focusout', '.dt-mobile-no', function () {
		var $this = $(this);
		var $row = $this.closest('tr');
		var mobileNo = $row.find('.dt-mobile-no').val();
		var memberId = $row.find('.dt-member-id').val();
		var isDuplicate = false;
		$('.dt-mobile-no').each(function () {
			var $otherRow = $(this).closest('tr');
			var otherMobileNo = $(this).val().trim();
			var otherMemberId = $otherRow.find('.dt-member-id').val();
			if(mobileNo !== '') {
				if (otherMobileNo === mobileNo && $row[0] !== $otherRow[0]) {
					isDuplicate = true;
					return false;
				}
			}
		});

		if (isDuplicate) {
			Swal.fire({
				title: 'Error!',
				text: "This Mobile No is already entered in another row!",
				icon: 'error',
				customClass: {
					confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
				},
				buttonsStyling: false
			});
			return;
		}

		$.ajax({
			url: "<?php echo admin_url('OwnershipFlat/addEditMember');?>",
			type: "POST",
			data: {
				mobile_no: mobileNo,
				member_id: memberId,
			},
			dataType: "json",
			beforeSend: function () {
                    $('#loader').show(); // Show loader before AJAX call
                },
			complete: function () {
                    $('#loader').hide(); // Hide loader after request finishes (success or error)
                },
			success: function (response) {
				if(!response.success){
					Swal.fire({
						title: 'Warning!',
						text: response.msg,
						icon: 'warning',
						showCancelButton: true,
						confirmButtonText: 'OK',
						customClass: {
							confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
							cancelButton: 'btn btn-label-secondary waves-effect waves-light'
						},
						buttonsStyling: false
					}).then(function(result) {
						if(result.isConfirmed && response.data){
							var birthDate = response.data.birth_date;
							if(birthDate != null && birthDate != "") {
								birthDate = moment(birthDate).format('DD-MM-YYYY');
							} else {
								birthDate = '';
							}
							$row.find('.dt-member-id').val(response.data.member_id);
							$row.find('.dt-name').val(response.data.name);
							$row.find('.dt-email-id').val(response.data.email_id);
							
							if (response.data.gender) {
							    $row.find('.dt-gender').each(function () {
							        if ($(this).val() === response.data.gender) {
							            $(this).prop('checked', true);
							        }
							    });
							}
							// $row.find('.dt-relation').val(response.data.relation);
							$row.find('.dt-birth-date').val(birthDate);
							$row.find('.dt-blood-group').val(response.data.blood_group).trigger('change');
						}
						else {
							$row.find('.dt-mobile-no').val('');
							$row.find('.dt-member-id').val('');
						}
					});
				}
				else{
				 	$row.find('.dt-member-id').val('');
				}		
			},
		});
	});


</script>
