<?php
$assets = base_url() . 'assets/';
$recordData = !empty($organic_waste_record_data) && is_array($organic_waste_record_data) ? $organic_waste_record_data : array();
$totalWaste = 0;
$totalCompost = 0;
$totalKitchenWaste = 0;
$totalProcessedCompost = 0;
$sawdust = 0;
$bacteria = 0;
$readyCompost = 0;
foreach ($recordData as $eKey => $record) {
	$totalWaste += $record['kitchen_waste'] + $record['processed_compost'] + $record['sawdust'];
	$totalCompost += $record['bacteria'] + $record['ready_compost'];
	$totalKitchenWaste += $record['kitchen_waste'];
	$totalProcessedCompost += $record['processed_compost'];
	$sawdust += $record['sawdust'];
	$bacteria += $record['bacteria'];
	$readyCompost += $record['ready_compost'];
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?= $name; ?></title>
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
		  type="text/css">

	<link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
	<link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>

<body style='font-family:chelvetica;font-size: 9px'>
<div class="row">
	<div class="col-xs-12">
		<h3 style="color: red;text-align: center;"><?= lang('OrganicWasteRecord.organic_waste_record_details'); ?></h3>
		<table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
			<tbody>
				<tr>
					<td colspan="4" rowspan="3"><center><strong><?= lang('OrganicWasteRecord.organic_waste_record'); ?></strong></center></td>
					<td colspan="2">
						<center><strong>
						<?php
							if (isset($society_data['society_name']) && $society_data['society_name'] != '') {
								echo $society_data['society_name'];
							} ?> 
						</strong></center>
					</td>
				</tr>
				<tr>
					<td><center><strong><?= lang('OrganicWasteRecord.from_date'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.to_date'); ?></strong></center></td>
				</tr></tr>
				<tr>
					<td><center><strong><?= isset($start_date) ? $start_date : ""; ?></strong></center></td>
					<td><center><strong><?= isset($end_date) ? $end_date : ""; ?></strong></center></td>
				</tr>
				<tr>
					<td colspan="2"><center><strong><?= lang('OrganicWasteRecord.total_waste'); ?></strong></center></td>
					<td><center><?= $totalWaste ;?></center></td>
					<td colspan="2"><center><strong><?= lang('OrganicWasteRecord.total_compost'); ?></strong></center></td>
					<td><center><?= $totalCompost ;?></center></td>
				</tr>
				<tr>
					<td rowspan="2"><center><strong><?= lang('OrganicWasteRecord.date'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.kitchen_waste'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.processed_compost'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.sawdust'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.bacteria'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.ready_compost'); ?></strong></center></td>
				</tr>
				<tr>
					<td><center><strong><?= lang('OrganicWasteRecord.100'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.70'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.12'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.010'); ?></strong></center></td>
					<td><center><strong><?= lang('OrganicWasteRecord.10'); ?></strong></center></td>
				</tr>
				<?php
						if (is_array($recordData) && !empty($recordData)) {
							foreach ($recordData as $eKey => $record) {
							// $totalWaste += $record['kitchen_waste'] + $record['processed_compost'] + $record['sawdust'];
							// $totalCompost += $record['bacteria'] + $record['ready_compost'];
							// $totalKitchenWaste += $record['kitchen_waste'];
							// $totalProcessedCompost += $record['processed_compost'];
							// $sawdust += $record['sawdust'];
							// $bacteria += $record['bacteria'];
							// $readyCompost += $record['ready_compost'];
						?>
								<tr>
									<td>
										<center><?= isValidDate($record['record_date']) ? siteDateFormat($record['record_date']) : ''; ?></center>
									</td>
									<td>
										<center><?= isset($record['kitchen_waste']) ? $record['kitchen_waste'] : ''; ?></center>
									</td>
									<td>
									<center><?= isset($record['processed_compost']) ? ($record['processed_compost']) : ''; ?></center>
									</td>
									<td>
									<center><?= isset($record['sawdust']) ? $record['sawdust'] : ''; ?></center>
									</td>
									<td>
									<center><?= isset($record['bacteria']) ? $record['bacteria'] : ''; ?></center>
									</td>
									<td>
									<center><?= isset($record['ready_compost']) ? $record['ready_compost'] : ''; ?></center>
									</td>
								</tr>
						<?php
							}
						} else {
							echo "<tr><td colspan='6' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
						} ?>
				<tr>
					<td><center><strong><?= lang('OrganicWasteRecord.total'); ?></strong></center></td>
					<td><center><?= $totalKitchenWaste ;?></td></center>
					<td><center><?= $totalProcessedCompost ;?></td></center>
					<td><center><?= $sawdust ;?></td></center>
					<td><center><?= $bacteria ;?></td></center>
					<td><center><?= $readyCompost ;?></td></center>
				</tr>
			</tbody>
		</table>	
	</div>
</div>
</body>
</html>
