<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#staff_detail" aria-controls="staff_detail" aria-selected="true">
			<?= lang('Staff.staff_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#attached-document" aria-controls="attached-document" aria-selected="false">
			<?= lang('Staff.staff_document'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="staff_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="staff_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Staff.staff_type"); ?></td>
						<td><?php
							echo (isset($staff_data['staff_type']) && $staff_data['staff_type'] != "") ? underscoreToUcWord($staff_data['staff_type']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Staff.staff_name"); ?></td>
						<td><?php
							echo (isset($staff_data['staff_name']) && $staff_data['staff_name'] != "") ? $staff_data['staff_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Staff.father_name"); ?></td>
						<td><?php
							echo (isset($staff_data['father_name']) && $staff_data['father_name'] != "") ? $staff_data['father_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Staff.date_of_birth"); ?></td>
						<td><?php
							echo (isset($staff_data['date_of_birth']) && $staff_data['date_of_birth'] != "") ? siteDateFormat($staff_data['date_of_birth']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Staff.gender"); ?></td>
						<td><?php
							echo (isset($staff_data['gender']) && $staff_data['gender'] != "") ? underscoreToUcWord($staff_data['gender']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Staff.work"); ?></td>
						<td><?php
							echo (isset($staff_data['work']) && $staff_data['work'] != "") ? $staff_data['work'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Staff.contact_no"); ?></td>
						<td><?php
							echo (isset($staff_data['contact_no']) && $staff_data['contact_no'] != "") ? $staff_data['contact_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Staff.present_address"); ?></td>
						<td><?php
							echo (isset($staff_data['present_address']) && $staff_data['present_address'] != "") ? $staff_data['present_address'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Staff.permanent_address"); ?></td>
						<td><?php
							echo (isset($staff_data['permanent_address']) && $staff_data['permanent_address'] != "") ? $staff_data['permanent_address'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Staff.reference"); ?></td>
						<td><?php
							echo (isset($staff_data['reference']) && $staff_data['reference'] != "") ? $staff_data['reference'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Staff.staff_image"); ?></td>
						<td>
							<?php 
		                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
		                        foreach($image_data as $image) { 
		                        	if(file_exists(STAFF_IMAGE_PATH . $image['staff_image'])){
				                        $paths = site_url() . STAFF_IMAGE_PATH . $image['staff_image']; ?> 
				                 		<span class="document-image-<?= $image['staff_image_id']; ?>">
				                 			<a href="<?= $paths; ?>" target="_blank"> <img src="<?= $paths; ?>" width="100" class="img-fluid" alt=""> </a>
				        				</span>
		            		<?php }} } ?>
						</td>
					</tr>
					
					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($staff_data['created_at']) && isValidDate($staff_data['created_at'])) ? siteDateFormat($staff_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($staff_data['created_by']) && $staff_data['created_by'] != "") ? $staff_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($staff_data['updated_at']) && isValidDate($staff_data['updated_at'])) ? siteDateFormat($staff_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($staff_data['updated_by']) && $staff_data['updated_by'] != "") ? $staff_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="attached-document" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="document_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th style="width: 10%"><?= lang("Staff.document_name"); ?></th>
						<th style="width: 10%"><?= lang("Staff.document_image"); ?></th>
					</tr>
				</thead>
				<tbody class="">
                	<?php if($document_data != '' && array_filter($document_data)) {
                    $sr = 1;
                    foreach ($document_data as $key => $value) { ?>
						<tr>
							<td class="text-center"><?= $sr; ?></td>
                            <td colspan="1"><?= underscoreToUcWord($value['document_name']); ?> </td>
                            <td colspan="1">
							<?php if (isset($value['module_image_data']) && $value['module_image_data'] != '' ) {?>
								<?php
								foreach($value['module_image_data'] as $document){
								$paths = site_url() . DOCUMENT_IMAGE_PATH . $document['document_image'];
								if(file_exists( DOCUMENT_IMAGE_PATH .$document['document_image'])){ ?>
									<a href="<?= $paths; ?>"  target="_blank">
										<img src="<?= $paths; ?>" width="100" height="100" class="img-fluid" alt="">
									</a>
								<?php } } } ?> 
							</td>
						</tr>
                    <?php $sr++;} }  else {   ?>
						<tr>
							<td colspan="3" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
						</tr>
					<?php } ?>
			</tbody>
			</table>
		</div>
	</div>
</div>