<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Meeting.meeting_detail'); ?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id' => 'form_meeting',
				);
				echo form_open_multipart('', $form_id);
				$meetingId = (isset($meeting_data['meeting_id']) && ($meeting_data['meeting_id'] != '')) ? $meeting_data['meeting_id'] : '';
				?>
				<input type="hidden" id="meeting_id" name="meeting_id" value="<?= $meetingId ?>">

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Meeting.meeting_title'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="meeting_title" id="meeting_title" placeholder="Enter <?= lang('Meeting.meeting_title'); ?>" value="<?= (isset($meeting_data['meeting_title']) && ($meeting_data['meeting_title'] != '')) ? $meeting_data['meeting_title'] : '';  ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Meeting.meeting_date_time'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="meeting_date_time" id="meeting_date_time" placeholder="Enter <?= lang('Meeting.meeting_date_time'); ?>" value="<?= (isset($meeting_data['meeting_date_time']) && isValidDate($meeting_data['meeting_date_time'])) ? siteDateFormat($meeting_data['meeting_date_time'], true) : ''; ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Meeting.meeting_agenda'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<textarea name="meeting_agenda" id="meeting_agenda" placeholder="Enter <?= lang('Meeting.meeting_agenda'); ?>" rows="3" cols="5" class="form-control"><?= (isset($meeting_data['meeting_agenda']) && ($meeting_data['meeting_agenda'] != '')) ? $meeting_data['meeting_agenda'] : ''; ?></textarea>
					</div>
				</div>

				<?php
				$imageExtension = array('jpeg' => 'jpeg', 'png' => 'png', 'pdf' => 'pdf', 'mp3' => 'mp3','jpg' => 'jpg');
				$imageAccept = imageAcceptExtension($imageExtension);
				$acceptImageFormat = '';
				foreach ($imageAccept as $image) {
					$acceptImageFormat = $acceptImageFormat ? $acceptImageFormat . ',' . $image : $image;
				}
				?>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Meeting.meeting_record'); ?></label>
					<div class="col-sm-10">
						<input type="file" class="form-control" name="meeting_record[]" multiple="multiple"
							accept="<?= $acceptImageFormat; ?>">
						<span class="form-text text-muted"><?= MEETING_UPLOAD_MESSAGE; ?></span>

						<?php
						if (isset($record_data) && is_array($record_data) && !empty($record_data)) {
							foreach ($record_data as $record) {
								if (file_exists(MEETING_RECORD_PATH . $record['meeting_record'])) {
									$paths = site_url() . MEETING_RECORD_PATH . $record['meeting_record'];
									$fileExtension = pathinfo($record['meeting_record'], PATHINFO_EXTENSION);?>
									<span class="document-record-<?= $record['meeting_record_id']; ?>"
										style="display: flex; align-items: center; padding-top: 1%; gap: 10px;">

										<!-- Show different elements based on file type -->
										<?php if (in_array($fileExtension, ['jpg', 'jpeg', 'png'])) { ?>
											<img src="<?= $paths; ?>" alt="Image Preview" width="100" height="100">
										<?php } elseif ($fileExtension == 'mp3' || $fileExtension == 'ogg') { ?>
											<audio controls>
												<source src="<?= $paths; ?>" type="audio/<?= $fileExtension; ?>">
											</audio>
										<?php } elseif ($fileExtension == 'pdf') { ?>
											<embed src="<?= $paths; ?>" type="application/pdf" width="100" height="100">
										<?php } elseif ($fileExtension == 'mp4') { ?>
											<video width="160" height="120" controls>
												<source src="<?= $paths; ?>" type="video/mp4">
											</video>
										<?php } ?>

										<!-- Download Button -->
										<a href="<?= $paths; ?>" download class="btn btn-outline-success">
											<i class="tf-icons ti ti-download"></i> Download
										</a>

										<!-- Delete Button (if user has permission) -->
										<?php if (!empty($meetingId) && $dtCIAcl->checkAccess("Meeting|meetingRecordDelete")) { ?>
											<a href="javascript:void(0);" id="<?= $record['meeting_record_id']; ?>"
												class="btn btn-icon btn-outline-dribbble delete-record">
												<i class="tf-icons ti ti-trash"></i>
											</a>
										<?php } ?>

									</span>

						<?php }
							}
						} ?>
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active'); ?></label>
					<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery" name="is_active" id="is_active" <?php echo (!isset($meeting_data['is_active']) || $meeting_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
							<span class="switch-toggle-slider">
								<span class="switch-on"></span>
								<span class="switch-off"></span>
							</span>

						</label>
					</div>
				</div>
				<div class="pt-4">
					<button type="submit" id="submitBtn"  class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Meeting'); ?>'" class="btn btn-label-secondary">Cancel</button>
				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	$(document).ready(function() {
		numberInit();
		towerDd();
		switcheryKeyGen("datatable-list-switchery");
		// Initialize
		var validator = $("#form_meeting").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				meeting_title: {
					required: true
				},
				meeting_date_time: {
					required: true,
				},
				meeting_agenda: {
					required: true,
				},
			},
			messages: {
				meeting_title: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Meeting.meeting_title'); ?>"
				},
				meeting_date_time: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Meeting.meeting_date_time'); ?>"
				},
				meeting_agenda: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Meeting.meeting_agenda'); ?>"
				},
			},
			submitHandler: function(e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Meeting/save"); ?>',
					type: 'post',
					beforeSubmit: function(formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function() {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Meeting');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Meeting');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								
								// timeOut: 1000
							});
						}
					}
				});
			}
		});

		$("#meeting_date_time").flatpickr({
			// monthSelectorType: 'static',
			enableTime: true,
			dateFormat: "d-m-Y H:i",
			// dateFormat: 'd-m-Y'
		});
	});

	$(document).on('click', '.delete-record', function() {
		var deleteId = $(this).attr("id");
		var meetingId = $("#meeting_id").val();
		Swal.fire({
			title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
			text: "<?= lang('CommonMessage.delete_warning'); ?>",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'OK',
			customClass: {
				confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
				cancelButton: 'btn btn-label-secondary waves-effect waves-light'
			},
			buttonsStyling: false
		}).then(function(result) {
			if (result.value) {
				$("span.document-record-" + deleteId).remove();
				$.ajax({
					type: "post",
					url: "<?= admin_url("Meeting/deleteMeetingRecord") ?>",
					dataType: "json",
					data: {
						meeting_record_id: deleteId,
						meeting_id: meetingId
					},
					success: function(data) {
						if (data['success']) {
							$(".delete-record").click(function() {
								$(this).parent().remove();
							});
							Swal.fire({
								title: 'Success',
								text: data['msg'],
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
						} else {
							Swal.fire({
								title: 'Error!',
								text: data['msg'],
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
						}
					}
				});
			}
		});
	});
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>