<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#material_detail" aria-controls="material_detail" aria-selected="true">
			<?= lang('Material.material_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#item_information" aria-controls="item_information" aria-selected="false">
			<?= lang('Material.material_items_detail'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="material_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="material_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Material.material_number"); ?></td>
						<td><?php
							echo (isset($material_data['document_number']) && $material_data['document_number'] != "") ? $material_data['document_number'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Material.material_date"); ?></td>
						<td><?php
							echo (isValidDate($material_data['material_date']) && $material_data['material_date'] != "") ? siteDateFormat($material_data['material_date']) : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Material.common_area"); ?></td>
						<td><?php
							echo (isset($material_data['common_area_name']) && $material_data['common_area_name'] != "") ? $material_data['common_area_name'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Material.material_type"); ?></td>
						<td><?php
							echo (isset($material_data['material_type']) && $material_data['material_type'] != "") ? underscoreToUcWord($material_data['material_type']) : '-';
							?>
						</td>
					</tr>
					<?php if(isset($material_data["material_type"]) && $material_data["material_type"] == 'inwards') { ?>
							<tr>
								<td><?= lang("Material.material_for"); ?></td>
								<td class="text-left"><?= isset($material_data["material_for"]) ? underscoreToUcWord($material_data["material_for"]) : ""; ?></td>
							</tr>
					<?php }?>
					<?php if(isset($material_reference_data) && !empty($material_reference_data)) { ?>
							<tr>
								<td><?= lang("Material.material_return"); ?></td>
								<td><?php
									echo implode(' , ', array_column($material_reference_data, 'material_return_number'));
									?>
								</td>
							</tr>
					<?php }?>									
					<tr>
						<td><?= lang("Material.financial_year"); ?></td>
						<td><?php
							echo (isset($material_data['financial_year_prefix']) && $material_data['financial_year_prefix'] != "") ? $material_data['financial_year_prefix'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("CommonMessage.common_form_submit"); ?></td>
						<td><?php
							echo (isset($material_data['form_submit']) && $material_data['form_submit'] != "") ? underscoreToUcWord($material_data['form_submit']) : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_approved_at"); ?></td>
						<td><?php
							echo (isset($material_data['approved_at']) && isValidDate($material_data['approved_at'])) ? siteDateFormat($material_data['approved_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_approved_by"); ?></td>
						<td><?php
							echo (isset($material_data['approved_by']) && $material_data['approved_by'] != 0) ? $material_data['approved_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($material_data['created_at']) && isValidDate($material_data['created_at'])) ? siteDateFormat($material_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($material_data['created_by']) && $material_data['created_by'] != "") ? $material_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($material_data['updated_at']) && isValidDate($material_data['updated_at'])) ? siteDateFormat($material_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($material_data['updated_by']) && $material_data['updated_by'] != "") ? $material_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>

	<div class="tab-pane fade" id="item_information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="item_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<?php
							if ((isset($material_item_data[0]['material_return_number'])) && !empty($material_item_data[0]['material_return_number'])) {
							?>
								<th><?= lang('Material.material_return'); ?></th>
						<?php }?>
						<th><?= lang("Material.item"); ?></th>
						<th><?= lang("Material.quantity"); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($material_item_data != '' && array_filter($material_item_data)) { ?>
						<?php
						$sr = 1;
						foreach ($material_item_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<?php if(isset($value['material_return_number']) && !empty($value['material_return_number'])){ ?>
									<td><?= isset($value['material_return_number']) ? $value['material_return_number'] : ''; ?></td>
								<?php }?>
								<td><?= $value['item_name']; ?> </td>
								<td><?= $value['quantity']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="4" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div>
</div>