<?php $dtCIAcl = new \App\Libraries\Dt_ci_acl(); ?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<!-- DataTable with Buttons -->
<div class="card">
	<div class="card-datatable  table-responsive">
		<table id="material_return_table" class="table dt-datatable ">
			<thead class="border-top">
			<tr>
				<th class="font-weight-bold"><?= lang("Material.material_number"); ?></th>
				<th class="font-weight-bold"><?= lang("Material.material_date"); ?></th>
				<th class="font-weight-bold"><?= lang("Material.common_area"); ?></th>
				<th class="font-weight-bold"><?= lang("Material.material_type"); ?></th>
				<th class="font-weight-bold"><?= lang("Material.item"); ?></th>
				<th class="font-weight-bold"><?= lang('Material.material_quantity'); ?></th>
				<th class="font-weight-bold"><?= lang('Material.material_return_quantity'); ?></th>
                <th class="font-weight-bold"><?= lang("Material.pending_quantity"); ?></th>
                <th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		commonAreaDd();
		itemDd();
		dt_DataTable = $('#material_return_table').DataTable( {
            dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
                '<"me-5 ms-n2 pe-5"f>' +
                '<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
                '>t' +
                '<"row mx-2"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search ',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			buttons: [
			{
					extend: 'collection',
					className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
					text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
					buttons: [
						{
							text: '<i class="ti ti-file me-2" ></i>Excel',
							className: 'dropdown-item dt-excel-export'
						},

					]
				}

			],
			"ajax": {
				"url": "<?php echo admin_url('Material/getMaterialButNotReturnDetailedListing'); ?>",
				"type": "POST",
				"data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
			},
			"order": [[ 0, "desc" ]],
			"columns": [
				{"data": "document_number" },
				{"data": "material_date", },
				{"data": "common_area_name" },
				{"data": "material_type" },
				{"data": "item_name" },
				{
					"data": "material_quantity",
					 searchable:false,
				},
				{
					"data": "material_return_quantity",
					 searchable:false, 
				},
				{
					"data": "pending_quantity",
					 searchable:false, 
				},
				{"data": "updated_by"},
				{"data": "updated_at"},
			],

			"fnDrawCallback": function (oSettings, json) {
                customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
                switcheryKeyGen("datatable-list-switchery");
			}
		});
		dtDataTableSearch();
	});




	$(document).on('click', '.dt-excel-export', function() {
		$(this).removeClass(".dt-excel-export");
		var dataTableParams = dt_DataTable.ajax.params();
		url = '<?= admin_url('Material/excelExportMaterialButNotReturn/') . ""  ?>';
		var recursiveEncoded = $.param(dataTableParams);
		$('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
		$('.dt-export-anchor')[0].click();
	});


    $(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});

    $(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #filter_common_area_id').val('').trigger('change');
        $('form#advanceFilter  #filter_item_id').val('').trigger('change');
        $('form#advanceFilter  #filter_material_type').val('').trigger('change');
		$("#filter_material_date").val('');
        dateRangePicker();
		dt_DataTable.draw();
	});


</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
