<?php 
$assets = base_url() . 'assets/';
$totalAmount = 0;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $name; ?></title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
          type="text/css">

    <link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
    <link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>

<body style='font-family:chelvetica;font-size: 9px'>
    <h3 style="color: red;text-align: center;"><?= lang('MaintenanceCalculation.maintenance_calculation_detail'); ?></h3>
    <table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
        <tr>
            <td colspan="5" rowspan="2"><center><strong>Maintenance</strong></center></td>
            <td colspan="6"><center><strong>
                <?php
                if (isset($society_data['society_name']) && $society_data['society_name'] != '') {
                    echo $society_data['society_name'];
                } ?> </strong></center>
            </td>
        </tr>
    
        <tr>
            <td colspan="3"><center><strong>Year</strong></center></td>
            <td colspan="3"><center><strong>
                <?php
                        if (isset($maintenance_calculation_data['calculation_date']) && $maintenance_calculation_data['calculation_date'] != '') {
                            echo date('Y',strtotime($maintenance_calculation_data['calculation_date']));
                        } ?> </strong></center>
            </td>
        </tr>
        <tr>
            <td><center><strong>SN</strong></center></td>
            <td><center><strong>Flat No</strong></center></td>
            <td><center><strong>SQR Ft</strong></center></td>
            <td><center><strong>Rate</strong></center></td>
            <td><center><strong>Maintenance</strong></center></td>
            <td><center><strong>GST</strong></center></td>
            <td><center><strong>Due Date</strong></center></td>
            <td><center><strong>Received Date</strong></center></td>
            <td><center><strong>Day</strong></center></td>
            <td><center><strong>Penalty</strong></center></td>
            <td><center><strong>Total</strong></center></td>
        </tr>
        <?php if(isset($maintenance_calculation_flat_data) && !empty($maintenance_calculation_flat_data)){?>
            <?php 
            $sn = 1; 
            $total = 0;
            $totalMaintenance = 0;
            $totalGst = 0;
            $totalPenalty = 0;
            foreach($maintenance_calculation_flat_data as $flatData){ 
                $total += isset($flatData['total']) ? $flatData['total'] : 0;
                $totalMaintenance += isset($flatData['maintenance']) ? $flatData['maintenance'] : 0;
                $totalGst += isset($flatData['gst']) ? $flatData['gst'] : 0;
                $totalPenalty += isset($flatData['penalty']) ? $flatData['penalty'] : 0;
                ?>
                <tr>
                    <td><center><?= $sn++; ?></center></td>
                    <td><center><?= isset($flatData['flat_no']) ? $flatData['flat_no'] : ''; ?></center></td>
                    <td><center><?= isset($flatData['sqr_ft']) ? $flatData['sqr_ft'] : ''; ?></center></td>
                    <td><center><?= isset($flatData['rate']) ? $flatData['rate'] : ''; ?></center></td>
                    <td><center><?= isset($flatData['maintenance']) ? $flatData['maintenance'] : ''; ?></center></td>
                    <td><center><?= isset($flatData['gst']) ? $flatData['gst'] : ''; ?></center></td>
                    <td><center><?= (isset($flatData['due_date']) && isValidDate($flatData['due_date'])) ? siteDateFormat($flatData['due_date']) : ''; ?></center></td>
                    <td><center><?= (isset($flatData['received_date']) && isValidDate($flatData['received_date'])) ? siteDateFormat($flatData['received_date']) : ''; ?></center></td>
                    <td><center><?= isset($flatData['day']) ? $flatData['day'] : ''; ?></center></td>
                    <td><center><?= isset($flatData['penalty']) ? $flatData['penalty'] : ''; ?></center></td>
                    <td><center><?= isset($flatData['total']) ? $flatData['total'] : ''; ?></center></td>
                </tr>
            <?php } ?>
                <tr>
                    <td colspan="4" style="text-align: right;"><strong>Total</strong></td>
                    <td><center><?= $totalMaintenance; ?></center></td>
                    <td><center><?= $totalGst; ?></center></td>
                    <td colspan="3"></td>
                    <td><center><?= $totalPenalty; ?></center></td>
                    <td><center><?= $total; ?></center></td>
                </tr>
        <?php }else { ?>
            <tr>
                <td colspan="11"><center><?= lang('CommonMessage.common_no_record_found'); ?></center></td>
            </tr>
        <?php } ?>
    </table>
</body>
</html>