<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$session = \Config\Services::session();
$invoiceView = isset($maintenance_calculation_data['view']) ? $maintenance_calculation_data['view'] : 0;
$maintenance_calculation_flat_data = isset($maintenance_calculation_flat_data) ? $maintenance_calculation_flat_data : array();
?>
<style>
    .form-control {
        width: auto !important;
    }
</style>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= lang('MaintenanceCalculation.maintenance_calculation_detail'); ?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id' => 'form_maintenance_calculation',
                );
                echo form_open_multipart('', $form_id);
                $maintenanceCalculationId = (isset($maintenance_calculation_data['id']) && ($maintenance_calculation_data['id'] != '')) ? $maintenance_calculation_data['id'] : '';
                ?>
                <input type="hidden" id="maintenance_calculation_id" name="maintenance_calculation_id"
                    value="<?= $maintenanceCalculationId ?>">
                <input type="hidden" id="delete_maintenance_calculation_flat_id" name="delete_maintenance_calculation_flat_id" value="">
                <div class="row g-3">

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('MaintenanceCalculation.calculation_date'); ?></label>
                        <input type="text" class="form-control" name="calculation_date" id="calculation_date"
                            placeholder="<?= lang('MaintenanceCalculation.calculation_date'); ?>" value="<?= isset($maintenance_calculation_data['calculation_date']) && isValidDate($maintenance_calculation_data['calculation_date']) ? siteDateFormat($maintenance_calculation_data['calculation_date']) : date('d-m-Y') ?>" />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label"
                            for="basic-default-name"><?= lang('MaintenanceCalculation.unit_of_measurement'); ?><span
                                class="text-danger"> *</span></label>
                        <!-- <div class="col-sm-10"> -->
                            <?php
                            $unitOfMesurement = unitOfMesurement();
                            ?>
                            <select
                                data-placeholder="Select  <?= lang('MaintenanceCalculation.unit_of_measurement'); ?>"
                                name="unit_of_measurement" id="unit_of_measurement"
                                class="form-control select dt-unit_of_measurement">
                                <!-- <option value=""> </option> -->
                                <?php
                                $selectedUnitOfMesurement = isset($maintenance_calculation_data['unit_of_measurement']) ? $maintenance_calculation_data['unit_of_measurement'] : "";
                                foreach ($unitOfMesurement as $unitOfMesurementKey => $unitOfMesurement) { ?>
                                    <option <?= ($selectedUnitOfMesurement == $unitOfMesurementKey) ? "selected" : ""; ?>
                                        value="<?= $unitOfMesurementKey; ?>"> <?= $unitOfMesurement; ?> </option>
                                <?php } ?>
                            </select>
                        <!-- </div> -->
                    </div>
                

                        <div class="col-md-6">
                            <label class="form-label" for="ownership_flat_ids">Select Flats</label>
                                <select id="ownership_flat_id" name="ownership_flat_id[]"
                                    class="select2 form-select ownerflatDd dt-flat" data-allow-clear="true" multiple>
                                    <option></option>
                                <?php foreach ($maintenance_calculation_flat_data as $key => $value) {
                                    # code...
                                
                                if (isset($value['flat_id']) && $value['flat_id'] != 0) { ?>
                                <option
                                    value="<?= isset($value['flat_id']) ? $value['flat_id'] : 0 ?>"
                                    selected>
                                    <?= isset($value['flat_no']) ? $value['flat_no'] : '' ?>
                                </option>
                            <?php } }?>
                        </select>
                    </div>
                
                    <div class="col-md-6">
                        <!-- <div class="form-check ms-2"> -->
                        <label class="form-label" for="is_select_all">Select All</label>
                        <input class="form-check-input" type="checkbox" id="is_select_all"
                            <?= isset($maintenance_calculation_data['is_select_all']) && $maintenance_calculation_data['is_select_all'] == 1 ? "checked" : '' ?> />
                        <!-- </div> -->
                    </div>
                
                    <div class="col-md-6">
                        <button type="button" class="btn btn-sm btn-primary" id="btn-generate-table">Generate
                            Table</button>
                    </div>
                </div>

                    <hr class="my-4 mx-n4" />
                    <h6>Flat information</h6>
                    <div class="row g-3">
                        <?= isset($flat_table) ? $flat_table : ""; ?>
                    </div>
                    <?php if ($dtCIAcl->checkAccess('MaintenanceCalculation|manage')) { ?>
                        <button type="button" class="btn btn-xs btn-primary" onclick="addMaintenanceCalculationFlatRow()">
                            <i class="ti ti-plus me-1"></i>
                            <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                        </button>
                    <?php } ?>

                    <div class="pt-4">
                        <button type="submit" id="submitBtn"
                            class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                        <button type="button" id="cancelBtn"
                            onclick="window.location.href='<?php echo admin_url('MaintenanceCalculation'); ?>'"
                            class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
                    </div>
                    <?php echo form_close(); ?>

                </div>
            </div>
        </div>
    </div>

    <script>

        function flatValidation() {
            addValidation("select", ".dt-flat-id", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> " + "<?= lang('MaintenanceCalculation.flat'); ?>",
                }
            });
            addValidation("input", ".dt-sqr_ft", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang('MaintenanceCalculation.sqr_ft'); ?>",
                }
            });
            addValidation("input", ".dt-rate", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang('MaintenanceCalculation.rate'); ?>",
                }
            });
            addValidation("input", ".dt-maintenance", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang('MaintenanceCalculation.maintenance'); ?>",
                }
            });
            addValidation("input", ".dt-gst", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang('MaintenanceCalculation.gst'); ?>",
                }
            });
            addValidation("input", ".dt-due_date", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang('MaintenanceCalculation.due_date'); ?>",
                }
            });
            addValidation("input", ".dt-received_date", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang('MaintenanceCalculation.received_date'); ?>",
                }
            });
            addValidation("input", ".dt-day", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang('MaintenanceCalculation.day'); ?>",
                }
            });
            addValidation("input", ".dt-penalty", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang('MaintenanceCalculation.penalty'); ?>",
                }
            });
            addValidation("input", ".dt-total", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> " + "<?= lang('MaintenanceCalculation.total'); ?>",
                }
            });
        }

        $(document).ready(function () {
            numberInit();
            switcheryKeyGen("datatable-list-switchery");
            ownerflatDd();
            flatDd();

            $(".dt-unit_of_measurement").select2();
            addSerialNumber('maintenance_calculation_flat_table');

            // Initialize
            var validator = $("#form_maintenance_calculation").validate({
                ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
                errorClass: 'validation-invalid-label',
                successClass: 'validation-valid-label',
                validClass: 'validation-valid-label',
                highlight: function (element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                unhighlight: function (element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                success: function (label) {
                    label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
                },
                // Different components require proper error label placement
                errorPlacement: function (error, element) {

                    // Unstyled checkboxes, radios
                    if (element.parents().hasClass('form-check')) {
                        error.appendTo(element.parents('.form-check').parent());
                    }

                    // Input with icons and Select2
                    else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                        error.appendTo(element.parent());
                    }

                    // Input group, styled file input
                    else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                        error.appendTo(element.parent().parent());
                    }

                    // Other elements
                    else {
                        error.insertAfter(element);
                    }
                },
                rules: {
                    calculation_date: {
                        required: true
                    },
                    unit_of_measurement: {
                        required: true
                    },
                    // "ownership_flat_id[]": {
                    //     required: true,
                    // },

                },
                messages: {
                    calculation_date: {
                        required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('MaintenanceCalculation.calculation_date'); ?>"
                    },
                    unit_of_measurement: {
                        required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('MaintenanceCalculation.unit_of_measurement'); ?>"
                    },
                    // "ownership_flat_id[]": {
                    //     required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('MaintenanceCalculation.ownership_flat_id'); ?>"
                    // },

                },
                submitHandler: function (e) {
                    $(e).ajaxSubmit({
                        url: '<?php echo admin_url("MaintenanceCalculation/save"); ?>',
                        type: 'post',
                        beforeSubmit: function (formData, jqForm, options) {
                            dtButtonHide('#submitBtn');
                            dtButtonHide('#cancelBtn');
                        },
                        complete: function () {

                        },
                        dataType: 'json',
                        clearForm: false,
                        success: function (resObj, statusText) {
                            if (resObj.success) {
                                toastr.success(resObj.msg, 'Success', {
                                    closeButton: true,
                                    progressBar: true,
                                    positionClass: 'toast-top-right',
                                    timeOut: 1000,
                                    onHidden: function () {
                                        dtButtonShow('#submitBtn');
                                        dtButtonShow('#cancelBtn');
                                        window.location.href = '<?php echo admin_url('MaintenanceCalculation'); ?>';
                                    }
                                });

                                // setTimeout(function () {
                                // 	window.location.href = '<?php echo admin_url('MaintenanceCalculation'); ?>';
                                // }, 1000);

                            } else {
                                dtButtonShow('#submitBtn');
                                dtButtonShow('#cancelBtn');
                                toastr.error(resObj.msg, 'Error', {
                                    closeButton: true,
                                    // progressBar: true,
                                    positionClass: 'toast-top-right',
                                    // timeOut: 1000
                                });
                            }
                        }
                    });
                }
            });
            flatValidation();
            $("#maintenance_calculation_date").flatpickr({
                dateFormat: "d-m-Y",
            });

            $("#due_date,.dt-due_date").flatpickr({
                dateFormat: "d-m-Y",
            });

            $("#calculation_date,.dt-received_date").flatpickr({
                dateFormat: "d-m-Y",
            });

        });

        $(document).on('change', '#is_select_all', function () {
            var isChecked = $(this).is(':checked');
            var $select = $('#ownership_flat_id');

            if (!isChecked) {
                // unselect all
                $select.val(null).trigger('change');
                return;
            }

            // select all
            var existingOptions = $select.find('option').filter(function () {
                return $(this).val() && $(this).val() !== "";
            });

            // If options are already loaded in DOM, just select them
            // if (existingOptions.length > 0) {
            //     var values = [];
            //     existingOptions.each(function () {
            //         values.push($(this).val());
            //     });
            //     $select.val(values).trigger('change');
            //     return;
            // }

            // Otherwise, fetch all flats via the same endpoint used by ownerflatDd (Select2)
            var ajaxUrl = "<?= admin_url('OwnershipFlat/getOwnershipFlatDd') ?>";

            function fetchPage(page, collectedIds) {
                $.ajax({
                    url: ajaxUrl,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        filter_param: '',
                        page: page
                    },
                    beforeSend: function () {
                        $('#loader').show(); // Show loader before AJAX call
                    },
                    success: function (data) {
                        if (!data || !data.result) {
                            $select.val(collectedIds).trigger('change');
                            return;
                        }

                        var perPage = data.result.length || 10;
                        var totalRows = data.totalRows || data.result.length;
                        var totalPages = Math.ceil(totalRows / perPage);

                        data.result.forEach(function (item) {
                            var id = item.id.toString();
                            if (collectedIds.indexOf(id) === -1) {
                                collectedIds.push(id);
                            }
                            if ($select.find('option[value="' + id + '"]').length === 0) {
                                var newOption = new Option(item.text, id, false, false);
                                $select.append(newOption);
                            }
                        });

                        if (page < totalPages) {
                            fetchPage(page + 1, collectedIds);
                        } else {
                            $select.val(collectedIds).trigger('change');
                        }
                    },
                    complete: function () {
                        $('#loader').hide(); // Hide loader after AJAX call
                    }
                });
            }

            fetchPage(1, []);
        });

        // ---------- GENERATE TABLE (client -> server) ----------
        $(document).on('click', '#btn-generate-table', function () {
            var calcDate = $('#calculation_date').val();
            var unit = $('#unit_of_measurement').val();
            // multiple select element id used earlier was 'ownership_flat_id' (or ownership_flat_ids in some snippets).
            // Use the actual element id in your page. I will try both to be safe.
            var flats = $('#ownership_flat_id').val() || $('#ownership_flat_ids').val() || [];
            
            if (!calcDate || !unit || flats.length === 0) {
                toastr.error('Please select Calculation Date, Unit of Measurement and at least one Flat.', 'Error');
                return;
            }

            // prepare payload
            var payload = {
                calculation_date: calcDate,
                unit_of_measurement: unit,
                flat_ids: flats // array
            };

            generateFlatRows(flats);
        });

        // When unit of measurement changes, refresh sqr_ft values for all existing rows
        $(document).on('change', '#unit_of_measurement', function () {
            var unit = $(this).val();
            var flatIds = [];
            $('#maintenance_calculation_flat_table tbody tr').each(function () {
                var flatId = $(this).find('.dt-flat-id').val();
                if (flatId && flatIds.indexOf(flatId) === -1) {
                    flatIds.push(flatId);
                }
            });

            if (flatIds.length === 0) {
                return;
            }

            refreshSqFtForAllRows(flatIds, unit);
        });
        
        function generateFlatRows(selectedFlatIds) {
            var unit = $('#unit_of_measurement').val();

            $.ajax({
                url: "<?= admin_url('Flat/getFlatDd') ?>",
                type: 'POST',
                dataType: 'json',
                data: {
                    flat_id: selectedFlatIds,
                    filter_param: '',
                    page: 1
                },
                success: function (data) {
                    var flatMap = {};

                    if (data && data.result) {
                        data.result.forEach(function (item) {
                            flatMap[item.id] = item;
                        });
                    }

                    var tbody = '';
                    selectedFlatIds.forEach(function (fid, idx) {
                        var rowNo = idx + 1;
                        // Get option text (flat label) if it exists in the select
                        var text = $('#ownership_flat_id option[value="' + fid + '"]').text() || $('#ownership_flat_ids option[value="' + fid + '"]').text() || fid;

                        var flatInfo = flatMap[fid] || {};
                        var sqVal = '';
                        if (unit === 'sqr_ft') {
                            sqVal = flatInfo.sqr_ft || '';
                        } else {
                            sqVal = flatInfo.carpet_area || '';
                        }

                        tbody += '<tr data-id="tr_' + rowNo + '">';
                        tbody += '<td class="dt-serial_number"></td>';
                        tbody += '<td>';
                        tbody += '<input type="hidden" name="maintenance_flat_id[' + rowNo + ']" class="maintenance_flat_id" value="">';
                        tbody += '<select name="flat_id[' + rowNo + ']" id="flat_id_' + rowNo + '" class="select2 form-selects dt-flat-id flatDd w-100">';
                        tbody += '<option value="' + fid + '" selected>' + text + '</option>';
                        tbody += '</select></td>';
                        tbody += '<td><input type="text" name="sqr_ft[' + rowNo + ']" id="sqr_ft_' + rowNo + '" class="form-control dt-sqr_ft" value="' + (sqVal !== null && sqVal !== undefined ? sqVal : '') + '" placeholder="Enter <?= lang('maintenanceCalculation.sqr_ft'); ?>" readonly></td>';
                        tbody += '<td><input type="text" name="rate[' + rowNo + ']" id="rate_' + rowNo + '" class="form-control dt-rate" value="" placeholder="Enter <?= lang('maintenanceCalculation.rate'); ?>"></td>';
                        tbody += '<td><input type="text" name="maintenance[' + rowNo + ']" id="maintenance_' + rowNo + '" class="form-control dt-maintenance" value="" readonly placeholder="Enter <?= lang('maintenanceCalculation.maintenance'); ?>"></td>';
                        tbody += '<td><input type="text" name="gst[' + rowNo + ']" id="gst_' + rowNo + '" class="form-control dt-gst" value="" placeholder="Enter <?= lang('maintenanceCalculation.gst'); ?>"></td>';
                        tbody += '<td><input type="text" name="due_date[' + rowNo + ']" id="due_date_' + rowNo + '" class="form-control dt-due_date" value="" placeholder="Enter <?= lang('maintenanceCalculation.due_date'); ?>"></td>';
                        tbody += '<td><input type="text" name="received_date[' + rowNo + ']" id="received_date_' + rowNo + '" class="form-control dt-received_date" placeholder="Enter <?= lang('maintenanceCalculation.received_date'); ?>" value=""></td>';
                        tbody += '<td><input type="text" name="day[' + rowNo + ']" id="day_' + rowNo + '" class="form-control dt-day" placeholder="Enter <?= lang('maintenanceCalculation.day'); ?>" value="" readonly></td>';
                        tbody += '<td><input type="text" name="penalty[' + rowNo + ']" id="penalty_' + rowNo + '" class="form-control dt-penalty" placeholder="Enter <?= lang('maintenanceCalculation.penalty'); ?>" value=""></td>';
                        tbody += '<td><input type="text" name="total[' + rowNo + ']" id="total_' + rowNo + '" class="form-control dt-total" placeholder="Enter <?= lang('maintenanceCalculation.total'); ?>" value="" readonly></td>';
                        tbody += '<td><button type="button" class="rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-calculation-row" data-bs-toggle="tooltip" data-bs-placement="top" title="<?= lang('MaintenanceCalculation.delete_calculation') ?>"><i class="ti ti-trash"></i></button></td>';
                        tbody += '</tr>';
                    });

                    $('#maintenance_calculation_flat_table tbody').html(tbody);

                    // init plugins like earlier
                    addSerialNumber('maintenance_calculation_flat_table');
                    $(".dt-flat-id").select2();
                    $(".dt-due_date").flatpickr({ dateFormat: "d-m-Y" });
                    $(".dt-received_date").flatpickr({ dateFormat: "d-m-Y" });
                    flatDd();
                    numberInit();
                    flatValidation();
                }
            });
        }

        function refreshSqFtForAllRows(selectedFlatIds, unit) {
            $.ajax({
                url: "<?= admin_url('Flat/getFlatDd') ?>",
                type: 'POST',
                dataType: 'json',
                data: {
                    flat_id: selectedFlatIds,
                    filter_param: '',
                    page: 1
                },
                success: function (data) {
                    var flatMap = {};
                    if (data && data.result) {
                        data.result.forEach(function (item) {
                            flatMap[item.id] = item;
                        });
                    }

                    $('#maintenance_calculation_flat_table tbody tr').each(function () {
                        var $row = $(this);
                        var flatId = $row.find('.dt-flat-id').val();
                        if (!flatId || !flatMap[flatId]) {
                            return;
                        }

                        var flatInfo = flatMap[flatId];
                        var sqVal = '';
                        console.log(unit);
                        
                        if (unit === 'sqr_ft') {
                            sqVal = flatInfo.sqr_ft || '';
                        } else {
                            sqVal = flatInfo.carpet_area || '';
                        }

                        $row.find('.dt-sqr_ft').val(sqVal);
                    });
                    calculateMaintenance($row);
                }
            });
        }

    </script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>