<?php
$html = '';
if (isset($maintenance_calculation_flat_data) && !empty($maintenance_calculation_flat_data)) {
	foreach ($maintenance_calculation_flat_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["maintenance_calculation_flat_data"] = $value;
		$html .= view('Admin/MaintenanceCalculation/MaintenanceCalculationFlatRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="maintenance_calculation_flat_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th style="width: 60px;"><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th style="width: 180px;"><?= lang('MaintenanceCalculation.flat'); ?><span class="text-danger"> *</span></th>
				<th style="width: 120px;"><?= lang('MaintenanceCalculation.sqr_ft'); ?><span class="text-danger"> *</span></th>
				<th style="width: 120px;"><?= lang('MaintenanceCalculation.rate'); ?><span class="text-danger"> *</span></th>
				<th style="width: 140px;"><?= lang('MaintenanceCalculation.maintenance'); ?><span class="text-danger"> *</span></th>
				<th style="width: 120px;"><?= lang('MaintenanceCalculation.gst'); ?><span class="text-danger"> *</span></th>
				<th style="width: 130px;"><?= lang('MaintenanceCalculation.due_date'); ?><span class="text-danger"> *</span></th>
				<th style="width: 140px;"><?= lang('MaintenanceCalculation.received_date'); ?></th>
				<th style="width: 90px;"><?= lang('MaintenanceCalculation.day'); ?></th>
				<th style="width: 130px;"><?= lang('MaintenanceCalculation.penalty'); ?></th>
				<th style="width: 130px;"><?= lang('MaintenanceCalculation.total'); ?></th>
				<th style="width: 90px;"><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($maintenance_calculation_flat_data) && !empty($maintenance_calculation_flat_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/MaintenanceCalculation/MaintenanceCalculationFlatRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addMaintenanceCalculationFlatRow() {
		var lastIndex = ($("#maintenance_calculation_flat_table tbody tr:last").length >= 1) ? $("#maintenance_calculation_flat_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('MaintenanceCalculation/addMaintenanceCalculationFlatRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#maintenance_calculation_flat_table tbody').append(data);
					addSerialNumber('maintenance_calculation_flat_table');
					flatDd();					
					customToolTip();
					flatValidation();
					numberInit();
					$(".dt-due_date").flatpickr({
						dateFormat: "d-m-Y",
					});
					$(".dt-received_date").flatpickr({
						dateFormat: "d-m-Y",
					});
				}
			}
		});
	}

	var deleteId = [];
	$(document).on('click', '.dt-delete-calculation-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".maintenance_flat_id").val();
		// var amenitiesId = $("#amenities_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					deleteId.push(id);
					$("#delete_maintenance_calculation_flat_id").val(deleteId);
                    $(trField).remove();
                    addSerialNumber('maintenance_calculation_flat_table');
					$(".dt-due_date").flatpickr({
						dateFormat: "d-m-Y",
					});
					$(".dt-received_date").flatpickr({
						dateFormat: "d-m-Y",
					});
                    if ($('#maintenance_calculation_flat_table tbody > tr').length == 0) {
                        addMaintenanceCalculationFlatRow();
                    }
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('maintenance_calculation_flat_table');
			if ($('#maintenance_calculation_flat_table tbody > tr').length == 0) {
                addMaintenanceCalculationFlatRow();
			}
		}
	});

	// $(document).on('change', '.dt-flat-id', function () {

	// });

	$(document).on("change keyup", ".dt-sqr_ft,.dt-rate, .dt-gst, .dt-penalty, .dt-due_date, .dt-received_date", function () {
		let rowNumber = $(this).attr("id").split("_").pop();
		calculateMaintenance(rowNumber);
	});

	function calculateMaintenance(rowNumber) {
		let sqFt = parseFloat($(`#sqr_ft_${rowNumber}`).val()) || 0;
		let rate = parseFloat($(`#rate_${rowNumber}`).val()) || 0;
		let gst = parseFloat($(`#gst_${rowNumber}`).val()) || 0;
		let penalty = parseFloat($(`#penalty_${rowNumber}`).val()) || 0;

		let dueDate = $(`#due_date_${rowNumber}`).val();
		let receivedDate = $(`#received_date_${rowNumber}`).val();

		// helper to parse dd-mm-YYYY safely
		function parseDMY(dateStr) {
			if (!dateStr) return null;
			let parts = dateStr.split('-');
			if (parts.length !== 3) return null;
			let d = parseInt(parts[0], 10);
			let m = parseInt(parts[1], 10) - 1; // month index
			let y = parseInt(parts[2], 10);
			if (isNaN(d) || isNaN(m) || isNaN(y)) return null;
			return new Date(y, m, d);
		}

		// Calculate maintenance
		let maintenance = sqFt * rate;
		$(`#maintenance_${rowNumber}`).val(maintenance.toFixed(2));

		// Calculate day difference
		let day = 0;
		let due = parseDMY(dueDate);
		if (due) {
			let compareDate = receivedDate ? parseDMY(receivedDate) : new Date();
			if (compareDate) {
				day = Math.ceil((compareDate - due) / (1000 * 60 * 60 * 24));
				day = day < 0 ? 0 : day; // No negative days
			}
		}
		$(`#day_${rowNumber}`).val(day);

		// Calculate total
		let total = maintenance + gst + (penalty * day);
		$(`#total_${rowNumber}`).val(total.toFixed(2));
	}

</script>