<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$rowNumber = isset($row_number) ? $row_number : 0;
$invoice_particular_data = isset($invoice_particular_data) ? $invoice_particular_data : array();
$voucherTransactionId = isset($invoice_particular_data['invoice_particular_id']) ? $invoice_particular_data['invoice_particular_id'] : array();

// Generate a default transaction name based on the row number if not set
$defaultTransactionName = "Transaction-" . ($rowNumber);  // Adding 1 because row number might be 0-indexed
?>
<tr data-id="tr_<?= $rowNumber; ?>">
	<td scope="row" class="dt-serial_number"></td>
	<td>
		<input type="hidden" id="invoice_particular_id_<?= $rowNumber; ?>"  name="invoice_particular_id[<?= $rowNumber; ?>]" class="invoice_particular_id" value="<?= isset($invoice_particular_data['invoice_particular_id']) ? $invoice_particular_data['invoice_particular_id'] : ""; ?>">
        <input type="hidden" name="particular_tax_json[<?= $rowNumber; ?>]"  id="particular_tax_json_<?= $rowNumber; ?>" class="particular_tax_json dt-particular-tax-json" value="<?= isset($invoice_particular_data['particular_tax_json']) ? htmlspecialchars($invoice_particular_data['particular_tax_json'], ENT_QUOTES, 'UTF-8') : "[]"; ?>">
        <input type="text" name="particular[<?= $rowNumber;?>]" id="particular_<?= $rowNumber;?>" class="form-control dt-particular" placeholder="Enter <?= lang('Invoice.particular'); ?>"  value="<?= isset($invoice_particular_data['particular']) ? $invoice_particular_data['particular'] : ""; ?>" />
	</td>

    <td>
        <input type="text" name="period_from[<?= $rowNumber;?>]" id="period_from_<?= $rowNumber;?>" class="form-control dt-period_from" placeholder="Enter <?= lang('Invoice.period_from'); ?>"  value="<?= (isset($invoice_particular_data['period_from']) && isValidDate($invoice_particular_data['period_from'])) ? siteDateFormat($invoice_particular_data['period_from']) : ''; ?>" />
	</td>
    
    <td>
        <input type="text" name="period_to[<?= $rowNumber;?>]" id="period_to_<?= $rowNumber;?>" class="form-control dt-period_to" placeholder="Enter <?= lang('Invoice.period_to'); ?>"  value="<?= (isset($invoice_particular_data['period_to']) && isValidDate($invoice_particular_data['period_to'])) ? siteDateFormat($invoice_particular_data['period_to']) : ''; ?>" />
	</td>

    <td>
        <input type="text" name="sq_ft[<?= $rowNumber;?>]" id="sq_ft_<?= $rowNumber;?>" class="form-control numberInit dt-sq_ft" placeholder="Enter <?= lang('Invoice.sq_ft'); ?>"  value="<?= isset($invoice_particular_data['sq_ft']) ? $invoice_particular_data['sq_ft'] : ""; ?>" />
	</td>

    <td>
        <input type="text" name="rate[<?= $rowNumber;?>]" id="rate_<?= $rowNumber;?>" class="form-control numberInit dt-rate" placeholder="Enter <?= lang('Invoice.rate'); ?>"  value="<?= isset($invoice_particular_data['rate']) ? $invoice_particular_data['rate'] : ""; ?>" />
	</td>

    <td>
        <input type="text" name="amount[<?= $rowNumber;?>]" id="amount_<?= $rowNumber;?>" class="form-control numberInit dt-amount" placeholder="Enter <?= lang('Invoice.amount'); ?>"  value="<?= isset($invoice_particular_data['amount']) ? $invoice_particular_data['amount'] : ""; ?>" />
	</td>
    <td>
        <select name="tax_id[<?= $rowNumber; ?>][]" id="tax_id_<?= $rowNumber;?>"  class="select2 form-selects dt-tax-id taxDd"  data-allow-clear="true">
            <?php 
                if(!empty($invoice_particular_data['tax_data'])){
                foreach ($invoice_particular_data['tax_data'] as $key => $value) {
                    if(isset($value['tax_id']) && $value['tax_id'] != 0){ ?>
    				<option value="<?= isset($value['tax_id']) ? $value['tax_id'] : 0 ?>" selected> <?= isset($value['tax_name']) ? $value['tax_name'] : ''  ?> </option>
                <?php } }
            }  ?>
		</select>
    </td>

    <td>
        <input type="text" name="total_amount[<?= $rowNumber;?>]" id="total_amount_<?= $rowNumber;?>" class="form-control numberInit dt-total_amount" placeholder="Enter <?= lang('Invoice.total_amount'); ?>"  value="<?= isset($invoice_particular_data['total_amount']) ? $invoice_particular_data['total_amount'] : ""; ?>" readonly/>
	</td>
	
	<td>
        <?php if (!empty($voucherTransactionId)) { ?>
            <?php if ($dtCIAcl->checkAccess('Invoice|deleteItem')) { ?>
                <button type="button"
                        class="rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-transaction-row"
                        data-bs-toggle="tooltip"
                        data-bs-placement="top" title="<?= lang('Invoice.delete_particular') ?>">
                    <i class="ti ti-trash"></i>
                </button>
            <?php } ?>
        <?php } else { ?>
            <button type="button" class=" rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-transaction-row"
                    data-bs-toggle="tooltip"
                    data-bs-placement="top" title="<?= lang('Invoice.delete_particular') ?>">
                <i class="ti ti-trash"></i>
            </button>
        <?php } ?>
    </td>

</tr>

