<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#investments_detail" aria-controls="investments_detail" aria-selected="true">
			<?= lang('Investments.investments_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#fdr-information" aria-controls="fdr-information" aria-selected="false">
			<?= lang('Investments.fdr_details'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#maturity-information" aria-controls="maturity-information" aria-selected="false">
			<?= lang('Investments.maturity_details'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="investments_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="investments_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Investments.financial_year"); ?></td>
						<td><?php
							echo (isset($investments_data['financial_year_prefix']) && $investments_data['financial_year_prefix'] != "") ? $investments_data['financial_year_prefix'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Investments.date"); ?></td>
						<td><?php
							echo (isset($investments_data['date']) && $investments_data['date'] != "") ? siteDateFormat($investments_data['date']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Investments.bank"); ?></td>
						<td><?php
							echo (isset($investments_data['bank_name']) && $investments_data['bank_name'] != "") ? $investments_data['bank_name'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td class="text-bold"><?= lang("Investments.created_at"); ?></td>
						<td><?php
							echo (isset($investments_data['created_at']) && isValidDate($investments_data['created_at'])) ? siteDateFormat($investments_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($investments_data['created_by']) && $investments_data['created_by'] != "") ? $investments_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($investments_data['updated_at']) && isValidDate($investments_data['updated_at'])) ? siteDateFormat($investments_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($investments_data['updated_by']) && $investments_data['updated_by'] != "") ? $investments_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="fdr-information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="fdr_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Investments.fdr_no"); ?></td>
						<td><?php
							echo (isset($investments_data['fdr_no']) && $investments_data['fdr_no'] != "") ? $investments_data['fdr_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Investments.fdr_amount"); ?></td>
						<td><?php
							echo (isset($investments_data['fdr_amount']) && $investments_data['fdr_amount'] != "") ? indianMoneyFormat($investments_data['fdr_amount'],2,0) : '-';
							?>
						</td>
					</tr>	
					<tr>
						<td><?= lang("Investments.term"); ?></td>
						<td><?php
							echo (isset($investments_data['term']) && $investments_data['term'] != "") ? $investments_data['term'] : '-';
							?>
						</td>
					</tr>	
					<tr>
						<td><?= lang("Investments.rate"); ?></td>
						<td><?php
							echo (isset($investments_data['rate']) && $investments_data['rate'] != "") ? indianMoneyFormat($investments_data['rate'],2,0) : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Investments.acrd_int"); ?></td>
						<td><?php
							echo (isset($investments_data['acrd_int']) && $investments_data['acrd_int'] != "") ? $investments_data['acrd_int'] : '-';
							?>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="maturity-information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="maturity_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Investments.maturity_date"); ?></td>
						<td><?php
							echo (isset($investments_data['maturity_date']) && $investments_data['maturity_date'] != "") ? siteDateFormat($investments_data['maturity_date']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Investments.maturity_amount"); ?></td>
						<td><?php
							echo (isset($investments_data['maturity_amount']) && $investments_data['maturity_amount'] != "") ? indianMoneyFormat($investments_data['maturity_amount'],2,0) : '-';
							?>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>