<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Gate.gate_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_gate',
				);
				echo form_open_multipart('',$form_id);
				$gateId = (isset($gate_data['gate_id']) && ($gate_data['gate_id'] != '')) ? $gate_data['gate_id'] : '';
				?>
				<input type="hidden" id="gate_id" name="gate_id" value="<?= $gateId ?>">

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Gate.gate_type');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<?php
							$gateTypes = gateType();
						?>
						<select data-placeholder="Select  <?= lang('Gate.gate_type'); ?>" name="gate_type"
							id="gate_type" class="select2 form-select dt-gate-type">
							<option value=""> </option>
							<?php
							$selectedGateType = isset($gate_data['gate_type']) ? $gate_data['gate_type'] : "";
							foreach ($gateTypes as $gateTypeKey => $gate_type) { ?>
								<option <?= ($selectedGateType == $gateTypeKey) ? "selected" : ""; ?>
									value="<?= $gateTypeKey; ?>"> <?= $gate_type; ?> </option>
							<?php } ?>
						</select>
					</div>
				</div>


				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Gate.gate_name');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">	
						<input type="text" class="form-control" name="gate_name" id="gate_name" placeholder="Enter <?= lang('Gate.gate_name');?>" value="<?= (isset($gate_data['gate_name']) && ($gate_data['gate_name'] != '')) ? $gate_data['gate_name'] : '';  ?>" />
					</div>
				</div>

                <div class="row mb-3 myDiv">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Gate.tower');?></label>
					<div class="col-sm-10">
						<select id="tower_id" name="tower_id" class="select2 form-select towerDd" data-allow-clear="<?= (empty($gateId)) ? 'true': '';  ?>">
                            <option></option>
                            <?php if(isset($gate_data['tower_id']) && $gate_data['tower_id'] != 0){ ?>
                                <option value="<?= isset($gate_data['tower_id']) ? $gate_data['tower_id'] : 0 ?>" selected> <?= isset($gate_data['tower_name']) ? $gate_data['tower_name'] : ''  ?> </option>
                            <?php } ?>
                        </select>
					</div>
				</div>

				

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
						<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($gate_data['is_active']) || $gate_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
							<span class="switch-toggle-slider">
		                          <span class="switch-on"></span>
		                          <span class="switch-off"></span>
		                        </span>
							
						</label>
					</div>
				</div>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Gate'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		switcheryKeyGen("datatable-list-switchery");
		$('.dt-gate-type').select2();
		towerDd();
        // Initialize
		var validator = $("#form_gate").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				gate_name: {
					required: true
				},
				gate_type: {
					required: true
				},
            },
            messages: {
				gate_name: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Gate.gate_name');?>"
				},
				gate_type: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Gate.gate_type');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Gate/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {
						// dtButtonShow('#submitBtn');
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Gate');?>';
                                }
							});
							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Gate');?>';
							// }, 1000);
						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });

    $(document).ready(function(){
        $("div.myDiv").hide();
        $('.dt-gate-type').on('change', function(){
            var gateType = $(this).val();
            if(gateType == "inside"){
                $("div.myDiv").show();
            }
            else{
				$("div.myDiv").hide();
            }
              
        });
        $('.dt-gate-type').change();              
	});

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
