<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable table-responsive">
		<table id="flat_table" class="table dt-datatable">
			<thead class="border-top">
			<tr>
				<th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
				<th class="font-weight-bold"><?= lang("Flat.flat_no"); ?></th>
				<th class="font-weight-bold"><?= lang('Flat.bhk'); ?></th>
				<th class="font-weight-bold"><?= lang('Flat.sqr_ft'); ?></th>
				<th class="font-weight-bold"><?= lang('Flat.tower'); ?></th>
				<th class="font-weight-bold"><?= lang('Flat.floor'); ?></th>
				<th class="font-weight-bold"><?= lang('Flat.carpet_area'); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_active"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
			</thead>
		</table>
		<div class="text-center mt-2" id="flat-summary-footer"></div>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		towerDd();
		dt_DataTable = $('#flat_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search <?= lang('Flat.flat');?>',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			buttons: [
				{
					extend: 'collection',
					className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
					text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
					buttons: [
						{
							text: '<i class="ti ti-file me-2" ></i>Excel',
							className: 'dropdown-item dt-excel-export'
						},
						<?php if ($dtCIAcl->checkAccess("Flat|pdf")) { ?> {
							extend: 'pdf',
							text: '<i class="ti ti-file-text me-2"></i>Pdf',
							className: 'dropdown-item',
							action: function() {
								window.location.href = '<?= admin_url('Flat/flatPdf'); ?>';
							}
						},
						<?php } ?>
					]
				},
				<?php if ($dtCIAcl->checkAccess("Flat|manage")) { ?>
				{
					text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Flat.add_flat');?></span>',
					className: 'add-new btn btn-primary px-1 me-2',
					action: function () {
						window.location.href = '<?= admin_url("Flat/manage");?>';
					}
				},
				<?php } ?>
				
				<?php if ($dtCIAcl->checkAccess("Flat|delete")) { ?>
				{
					text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Flat.delete_flat');?></span>',
					className: 'btn btn-danger  px-1 dt-delete-record',
				},
				<?php } ?>
			],
			"ajax": {
				"url": "<?php echo admin_url('Flat/getFlatListing'); ?>",
				"type": "POST",
				"data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
			},
			"stateSave": true,
			"order": [[ 0, "asc" ]],
			"columns": [
				{
					"data": "flat_id",
					"render": function (data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['flat_id'] + '" name="ids[]" value="' + row['flat_id'] + '"/>';
					},
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{"data": "flat_no" },
				{"data": "bhk"},
				{"data": "sqr_ft"},
				{"data": "tower_name", "class": "no_click_allowed"},
				{"data": "floor"},
				{"data": "carpet_area"},
				{
					"data": "is_active",
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false,
					"render": function (data, type, row) {
						var checked = (data == 1) ? "checked" : "";
						return '<label class="switch switch-primary switch-sm">' +
							'<input type="checkbox" class="switch-input  dt-active-status" ' + checked + '  data-id="' + row['flat_id'] + '" value="1" />' +
							'<span class="switch-toggle-slider">' +
							'<span class="switch-on"></span>' +
							'<span class="switch-off"></span>' +
							'</span>';
						'</label>';
					}
				},
				{
					"data": "action_button",
					"class" : "text-center no_click_allowed",
					"sortable": false,
					"searchable": false
				},
			],
			createdRow: function (row, data, dataIndex) {
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").addClass('dt-detail-model-view');
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_id', data['flat_id']);
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_url', '<?= admin_url("Flat/view"); ?>');
			},
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

				// center the info text
				var $info = $(oSettings.nTableWrapper).find('.dataTables_info');
				// $info.addClass('text-center w-100');
			},
			"fnInfoCallback": function(oSettings, iStart, iEnd, iMax, iTotal, sPre) {
				// sPre = default "Displaying _START_ to _END_ of _TOTAL_ entries"
				var totalFlats       = <?= isset($flat_summary['total_flats']) ? (int)$flat_summary['total_flats'] : 0 ?>;
				var totalCarpetArea  = <?= isset($flat_summary['total_carpet_area']) ? (float)$flat_summary['total_carpet_area'] : 0 ?>;
				var totalSqrFt       = <?= isset($flat_summary['total_sqr_ft']) ? (float)$flat_summary['total_sqr_ft'] : 0 ?>;

				var summary = 'Total Flats: ' + totalFlats +
					' | Total Carpet Area: ' + totalCarpetArea +
					' | Total Sq. Ft.: ' + totalSqrFt;

				// combine default info text + summary
				return sPre + ' | ' + summary;
			},
		});
		dtDataTableSearch();
	});


	$(document).on('click', '.dt-active-status', function () {
		var id = $(this).attr('data-id');
		var isActive = $(this).is(":checked") ? 1 : 0;
		$.ajax({
			type: 'post',
			url: '<?php echo admin_url('Flat/changeStatus'); ?>',
			data: {flat_id:id, status: isActive},
			dataType: 'json',
			success: function (data) {
				if (data) {
					Swal.fire({
						title: 'Success',
						text: data.msg,
						icon: 'success',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					}).then(function() {
						dt_DataTable.ajax.reload(null,false);
					});
				} else {
					Swal.fire({
						title: 'Error!',
						text: data.msg,
						icon: 'error',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					});
				}
			}
		});
	});

    //Delete Record
    $(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#flat_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("Flat/delete")?>",
                        dataType: "json",
                        data: {flat_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });

	$(document).on('click', '.datatable-checkbox', function () {
		$(".dt-delete-record").removeClass( "invisible" );

	});

	$(document).on('click', '.dt-excel-export', function() {
		$(this).removeClass(".dt-excel-export");
		var dataTableParams = dt_DataTable.ajax.params();
		url = '<?= admin_url('Flat/excelExportFlat/') . ""  ?>';
		var recursiveEncoded = $.param(dataTableParams);
		$('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
		$('.dt-export-anchor')[0].click();
	});

		$(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});


	$(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #filter_tower_id').val('').trigger('change');
		dt_DataTable.draw();
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>