<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Flat.flat_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_flat',
				);
				echo form_open_multipart('',$form_id);
				$flatId = (isset($flat_data['flat_id']) && ($flat_data['flat_id'] != '')) ? $flat_data['flat_id'] : '';
				?>
				<input type="hidden" id="flat_id" name="flat_id" value="<?= $flatId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Flat.tower');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="tower_id" name="tower_id" class="select2 form-select form-select-lg dt-tower towerDd" data-allow-clear="true">
								<?php if(isset($flat_data['tower_id']) && $flat_data['tower_id'] != 0){ ?>
                                <option value="<?= isset($flat_data['tower_id']) ? $flat_data['tower_id'] : 0 ?>" selected> <?= isset($flat_data['tower_name']) ? $flat_data['tower_name'] : ''  ?> </option>
                            <?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Flat.floor');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="floor_id" name="floor_id" class="select2 form-select form-select-lg dt-tower-unit towerUnitDd" data-allow-clear="true">
								<?php if(isset($flat_data['floor_id']) && $flat_data['floor_id'] != 0){ ?>
                                <option value="<?= isset($flat_data['floor_id']) ? $flat_data['floor_id'] : 0 ?>" selected> <?= isset($flat_data['floor']) ? $flat_data['floor'] : ''  ?> </option>
                            <?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Flat.flat_no');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="flat_no" id="flat_no" placeholder="Enter <?= lang('Flat.flat_no');?>" value="<?= (isset($flat_data['flat_no']) && ($flat_data['flat_no'] != '')) ? $flat_data['flat_no'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Flat.bhk');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit dt-bhk" name="bhk" id="bhk" placeholder="Enter <?= lang('Flat.bhk');?>" value="<?= (isset($flat_data['bhk']) && ($flat_data['bhk'] != '')) ? roundNumber($flat_data['bhk']) : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Flat.sqr_ft');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit dt-sqr-ft" name="sqr_ft" id="sqr_ft" placeholder="Enter <?= lang('Flat.sqr_ft');?>" value="<?= (isset($flat_data['sqr_ft']) && ($flat_data['sqr_ft'] != '')) ? roundNumber($flat_data['sqr_ft']) : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Flat.carpet_area');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit dt-carpet-area" name="carpet_area" id="carpet_area" placeholder="Enter <?= lang('Flat.carpet_area');?>" value="<?= (isset($flat_data['carpet_area']) && ($flat_data['carpet_area'] != '')) ? roundNumber($flat_data['carpet_area']) : '';  ?>" />
						</div>
					</div>
					<?php /*?>	
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Flat.floor');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="floor" id="floor" placeholder="Enter <?= lang('Flat.floor');?>" value="<?= isset($flat_data['floor']) ? ($flat_data['floor']) : '';  ?>" />
						</div>
					</div>
					<?php */?>		
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($flat_data['is_active']) || $flat_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Flat'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
    	<?php 
    	if(!empty($flatId)){ ?>
    		$(".dt-tower").select2();
    		$(".dt-tower-unit").select2();
    	<?php } else{ ?>
    		towerDd();
    		towerUnitDd();
    	<?php }
    	?>
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_flat").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				flat_no: {
					required: true
				},
				sqr_ft : {
					required: true
				},
				bhk : {
					required: true
				},
				tower_id : {
					required: true
				},
				carpet_area : {
					required: true
				},
				floor_id : {
					required: true
				},
            },
            messages: {
				flat_no: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Flat.flat_no');?>"
				},
				sqr_ft : {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Flat.sqr_ft');?>"
				},
				bhk : {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Flat.bhk');?>"
				},
				tower_id : {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Flat.tower');?>"
				},
				carpet_area : {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Flat.carpet_area');?>"
				},
				floor_id : {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Flat.floor');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Flat/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Flat');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Flat');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
