<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Faq.faq_form');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_faq',
				);
				echo form_open_multipart('',$form_id);
				$faqId = (isset($faq_data['faq_id']) && ($faq_data['faq_id'] != '')) ? $faq_data['faq_id'] : '';
				?>
				<input type="hidden" id="faq_id" name="faq_id" value="<?= $faqId ?>">
				<input type="hidden" id="category_for" name="category_for" value="faq">
                <div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Faq.category_id');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
					<select id="category_id" name="category_id" class="select2 form-select form-select-lg categoryDd" data-allow-clear="true">
							<option></option>
							<?php if(isset($faq_data['category_id']) && $faq_data['category_id'] != 0){ ?>
							<option value="<?= isset($faq_data['category_id']) ? $faq_data['category_id'] : 0 ?>" selected> <?= isset($faq_data['category_name']) ? $faq_data['category_name'] : ''  ?> </option>
							<?php } ?>
					</select>
					</div>
				</div>


				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Faq.faq_title');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="faq_title" id="faq_title" placeholder="Enter <?= lang('Faq.faq_title');?>" value="<?= (isset($faq_data['faq_title']) && ($faq_data['faq_title'] != '')) ? $faq_data['faq_title'] : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Faq.faq_answer'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <textarea name="faq_answer"  id="faq_answer" placeholder="Enter <?= lang('Faq.faq_answer'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($faq_data['faq_answer']) && ($faq_data['faq_answer'] != '')) ? $faq_data['faq_answer'] : ''; ?></textarea>
                    </div>
                </div>
				
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Faq.sort_order');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control numberInit" name="faq_sort_order" id="faq_sort_order" placeholder="Enter <?= lang('Faq.sort_order');?>" value="<?= (isset($faq_data['sort_order']) && ($faq_data['sort_order'] != '')) ? $faq_data['sort_order'] : '';  ?>" />
					</div>
				</div>

				<hr class="my-4 mx-n4" />
				<h6><?= lang('Media.media_information'); ?></h6>
				<div class="row g-3">
					<?= isset($media_table) ? $media_table : ""; ?>
	    		</div>
				<?php if ($dtCIAcl->checkAccess('OwnershipFlat|manage')) { ?>
					<button type="button" class="btn btn-sm btn-primary" onclick="addMediaItem()" data-bs-popup='tooltip' title="<?= lang('CommonMessage.common_add_media') ?>">
	            		<i class="ti ti-plus me-1"></i>
	            		<span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
	        		</button>
	   			 <?php } ?>

				<div class="pt-4">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Faq'); ?>'" class="btn btn-label-secondary">Cancel</button>
				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	$(document).ready(function() {
		numberInit();
		addSerialNumber('media_table');
		switcheryKeyGen("datatable-list-switchery");
		$('.dt-media-type').select2();
		$('.dt-faq').select2();
		categoryDd();
		// Initialize
		var validator = $("#form_faq").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				faq_title: {
					required: true,
				},
				category_id: {
					required: true,
				},
				faq_sort_order: {
					required: true,
					digits : true,
				},
				faq_answer: {
					required: true,
				}
			},
			messages: {
				faq_title: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Faq.faq_title"); ?>',
				},
				category_id: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Faq.category_id"); ?>',
				},
				faq_sort_order: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Faq.sort_order"); ?>',
				},
				faq_answer: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Faq.faq_answer"); ?>',
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Faq/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Faq');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Faq');?>';
							// }, 1000);

						} else {
							dtButtonShow("#submitBtn");
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>