<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$eventBookingId = (isset($event_booking_data['event_booking_id']) && ($event_booking_data['event_booking_id'] != '')) ? $event_booking_data['event_booking_id'] : '';
$eventView = isset($event_booking_data['view']) ? $event_booking_data['view'] : 0;

?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('EventBooking.event_booking_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_event',
				);
				echo form_open_multipart('',$form_id);
				$isEventBookingBooked = (isset($event_booking_is_booked) && ($event_booking_is_booked != 0)) ? $event_booking_is_booked : '';
				?>
				<input type="hidden" id="event_booking_id" name="event_booking_id" value="<?= $eventBookingId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EventBooking.event');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<select id="event_id" name="event_id" class="select2 form-select form-select-lg eventDd dt-event" data-allow-clear="true">
							<option></option>
							<?php if(isset($event_booking_data['event_id']) && $event_booking_data['event_id'] != 0){ ?>
							<option value="<?= isset($event_booking_data['event_id']) ? $event_booking_data['event_id'] : 0 ?>" selected> <?= isset($event_booking_data['event_name']) ? $event_booking_data['event_name'] : ''  ?> </option>
							<?php } ?>
						</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EventBooking.start_date');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="start_date" id="start_date" placeholder="Enter <?= lang('EventBooking.start_date');?>" value="<?= (isset($event_booking_data['start_date']) && isValidDate($event_booking_data['start_date'])) ? siteDateFormat($event_booking_data['start_date']) : ''; ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EventBooking.end_date');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="end_date" id="end_date" placeholder="Enter <?= lang('EventBooking.end_date');?>" value="<?= (isset($event_booking_data['end_date']) && isValidDate($event_booking_data['end_date'])) ? siteDateFormat($event_booking_data['end_date']) : ''; ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EventBooking.member');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<select id="ownership_flat_member_id" name="ownership_flat_member_id" class="select2 form-select form-select-lg getFlatMemberDd dt-ownership-flat-member" data-allow-clear="true">
							<option></option>
							<?php if(isset($event_booking_data['ownership_flat_member_id']) && $event_booking_data['ownership_flat_member_id'] != 0){ ?>
							<option value="<?= isset($event_booking_data['ownership_flat_member_id']) ? $event_booking_data['ownership_flat_member_id'] : 0 ?>" selected> <?= isset($event_booking_data['name']) ? $event_booking_data['name'] : ''  ?> </option>
							<?php } ?>
						</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EventBooking.total_adult');?><span class="text-danger"> </span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="total_adult" id="total_adult" placeholder="Enter <?= lang('EventBooking.total_adult');?>" value="<?= (isset($event_booking_data['total_adult']) && ($event_booking_data['total_adult'] != '')) ? $event_booking_data['total_adult'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EventBooking.total_child');?><span class="text-danger"> </span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="total_child" id="total_child" placeholder="Enter <?= lang('EventBooking.total_child');?>" value="<?= (isset($event_booking_data['total_child']) && ($event_booking_data['total_child'] != '')) ? $event_booking_data['total_child'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EventBooking.total_guest');?><span class="text-danger"> </span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="total_guest" id="total_guest" placeholder="Enter <?= lang('EventBooking.total_guest');?>" value="<?= (isset($event_booking_data['total_guest']) && ($event_booking_data['total_guest'] != '')) ? $event_booking_data['total_guest'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EventBooking.total_payment');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="total_payment" id="total_payment" placeholder="Enter <?= lang('EventBooking.total_payment');?>" value="<?= (isset($event_booking_data['total_payment']) && ($event_booking_data['total_payment'] != '')) ? $event_booking_data['total_payment'] : '';  ?>" readonly />
						</div>
					</div>

					<div class="pt-4">
						<button type="button" class="btn btn-primary get-total-payment">Get Total Payment</button>
					</div>

					<?php if ($eventView != 1) { ?>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('EventBooking'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
					<?php } ?>

				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
        var editable = <?= $eventView ?>;
        if (editable == 1) {
            $("#form_event :input").prop("disabled", true);
        }
    $(document).ready(function() {
    	numberInit();
		nonDecimal();
    	eventDd();
    	getFlatMemberDd();
		$("#start_date").flatpickr({
    		dateFormat: "d-m-Y",
		});
		$("#end_date").flatpickr({
    		dateFormat: "d-m-Y",
		});
		
		switcheryKeyGen("datatable-list-switchery");

	    // Initialize
		var validator = $("#form_event").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				event_id: {
					required: true,
				},
				start_date: {
					required: true,
				},
				end_date: {
					required: true,
				},
				ownership_flat_member_id: {
					required: true,
				},
				// total_adult: {
				// 	required: true,
				// },
				// total_child : {
                //     required: true,
                // },
				// total_guest : {
                //     required: true,
                // },
				total_payment : {
                    required: true,
                },
            },
            messages: {
				event_id: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang(line: "EventBooking.event"); ?>',
				},
				start_date: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("EventBooking.start_date"); ?>',
				},
				end_date: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("EventBooking.end_date"); ?>',
				},
				ownership_flat_member_id: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("EventBooking.member"); ?>',
				},
				total_payment: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("EventBooking.total_payment"); ?>',
				},
				
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("EventBooking/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('EventBooking');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('EventBooking');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });

	$(document).on('click','.get-total-payment', function () {
        var eventId    = $('#event_id').val();
		var startDate = $('#start_date').val();
        var endDate = $('#end_date').val();
        var totalAdult = $('#total_adult').val();
        var totalChild = $('#total_child').val();
        var totalGuest = $('#total_guest').val();
        $.ajax({
            type: "POST",
            url: "<?php echo admin_url('EventBooking/getTotalPayment'); ?>",
            dataType: "json",
            data: {
                event_id : eventId,
                start_date : startDate,
                end_date : endDate,
                total_adult : totalAdult,
                total_child : totalChild,
                total_guest : totalGuest,
            },
            success: function (resObj) {
                if (resObj.success) {
                    $('#total_payment').val(resObj.total_payment);
                } else {
					toastr.error(resObj.msg, 'Error', {
						closeButton: true,
						positionClass: 'toast-top-right',
					});
				}
            }  
        });
    });

	$(document).on('change','#event_id', function () {
		$('#start_date').val('');
        $('#end_date').val('');
        $('#total_adult').val('');
        $('#total_child').val('');
        $('#total_guest').val('');
        $('#total_payment').val('');
    });

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
