<div class="modal fade" id="cancel_event_booking_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
        <div class="modal-content p-3 p-md-5">
            <div class="modal-body">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="text-center mb-4">
                    <h3 class="mb-2">Cancel Event Booking</h3>
                </div>

                <?php
                $form_id = array(
                    'id'        => 'form_cancel_event_booking_modal',
                    'method'    => 'post',
                    'class'     => 'row g-3',
                    'autocomplete' => 'off'
                ); ?>
                <?= form_open('', $form_id); ?>

                <input type="hidden" name="modal_event_booking_id" id="modal_event_booking_id">
                <div class="col-12">
                    <label class="form-label" for="modalAddCardName"><?= lang('EventBooking.cancel_reason'); ?><span class="text-danger"> </span></label>
                    <textarea name="cancel_reason" id="cancel_reason" placeholder="Enter <?= lang('EventBooking.cancel_reason'); ?>" rows="3" cols="5" class="form-control"></textarea>
                </div> 
                <div class="col-12 text-center">
                    <button type="submit" class="btn btn-primary me-sm-3 me-1">Submit</button>
                    <button type="reset" class="btn btn-label-secondary btn-reset" data-bs-dismiss="modal" aria-label="Close">
                        Cancel
                    </button>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
		// Initialize
		var validator = $("#form_cancel_event_booking_modal").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				// remarks : {
				// 	required : true,
				// }
			},
			messages: {
				// remarks : {
				// 	required: "<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("EventBooking.remarks"); ?>",
				// }
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("EventBooking/cancelEventBooking");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {

					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
                            $('#cancel_event_booking_modal').modal('hide');
							Swal.fire({
								title: 'Success',
								text: resObj.msg,
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								window.location.href = '<?php echo admin_url('EventBooking');?>';
							});

						} else {
							Swal.fire({
								title: 'Error!',
								text: resObj.msg,
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							});
						}
					}
				});
			}
		});

		
	});

</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>