<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#staff_detail" aria-controls="staff_detail" aria-selected="true">
			<?= lang('DocumentFolder.document_folder_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#attached-document" aria-controls="attached-document" aria-selected="false">
			<?= lang('DocumentFolder.document_folder_item_detail'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="staff_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="staff_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("DocumentFolder.folder_name"); ?></td>
						<td><?php
							echo (isset($document_folder_data['folder_name']) && $document_folder_data['folder_name'] != "") ? ($document_folder_data['folder_name']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($document_folder_data['created_at']) && isValidDate($document_folder_data['created_at'])) ? siteDateFormat($document_folder_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($document_folder_data['created_by']) && $document_folder_data['created_by'] != "") ? $document_folder_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($document_folder_data['updated_at']) && isValidDate($document_folder_data['updated_at'])) ? siteDateFormat($document_folder_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($document_folder_data['updated_by']) && $document_folder_data['updated_by'] != "") ? $document_folder_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="attached-document" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="document_folder_items_detail" class="table table-bordered">
				<thead>
					<tr>
						<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th style="width: 10%"><?= lang("DocumentFolder.document_folder_title"); ?></th>
						<th style="width: 10%"><?= lang("DocumentFolder.effective_date"); ?></th>
						<th style="width: 10%"><?= lang("DocumentFolder.description"); ?></th>
						<th style="width: 10%"><?= lang("DocumentFolder.image"); ?></th>
					</tr>
				</thead>
				<tbody class="">
                	<?php if($document_folder_item_data != '' && array_filter($document_folder_item_data)) {
                    $sr = 1;
                    foreach ($document_folder_item_data as $key => $value) { ?>
						<tr>
							<td class="text-center"><?= $sr; ?></td>
                            <td colspan="1"><?= $value['document_folder_title']; ?> </td>
                            <td colspan="1"><?= YMDToDMY($value['effective_date']); ?> </td>
                            <td colspan="1"><?= $value['description']; ?> </td>
                            <td colspan="1">
								<?php if (isset($value['document_image']) && $value['document_image'] != '' ) { ?>
									<?php
										if(isset($value['document_image']) && file_exists(DOCUMENT_IMAGE_PATH . $value['document_image'])) {
											$file = site_url().DOCUMENT_IMAGE_PATH . $value['document_image'];
											$exp = explode('.',$file);
											foreach($exp  as $ex)
											{
												if($ex == 'pdf'){	
													$fileUrl = site_url('uploads/pdf_image.jpg');
												}
												else{
													$fileUrl = site_url().DOCUMENT_IMAGE_PATH . $value['document_image'];
												}
											} ?>
											<a href="<?= $file; ?>" target="_blank"><img style="width: 50px;height: 50px;" src="<?= $fileUrl; ?>"></a>
										<?php } } ?>
							</td>
						</tr>
                    <?php $sr++;} }  else {   ?>
						<tr>
							<td colspan="5" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
						</tr>
					<?php } ?>
			</tbody>
			</table>
		</div>
	</div>
</div>