<?php 
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$session = \Config\Services::session();
?>

<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('DocumentFolder.document_folder_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_document_folder',
				);
				echo form_open_multipart('',$form_id);
				$documentFolderId = (isset($document_folder_data['document_folder_id']) && ($document_folder_data['document_folder_id'] != '')) ? $document_folder_data['document_folder_id'] : '';
				?>
				<input type="hidden" id="document_folder_id" name="document_folder_id" value="<?= $documentFolderId ?>">
				<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('DocumentFolder.folder_name');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="folder_name" id="folder_name" placeholder="Enter <?= lang('DocumentFolder.folder_name');?>" value="<?= (isset($document_folder_data['folder_name']) && ($document_folder_data['folder_name'] != '')) ? $document_folder_data['folder_name'] : '';  ?>" />
						</div>
					</div>
                    <?php /* ?>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php if(isset($document_folder_data['is_active']) && $document_folder_data['is_active'] == 1) {  echo 'checked="checked"'; } else { echo ''; } ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>
                    <?php */?>

					<hr class="my-4 mx-n4" />
                    <h6>2. <?= lang('DocumentFolder.document_folder_item_information'); ?></h6>
                    <div class="row g-3">
                        <?= isset($document_folder_item_table) ? $document_folder_item_table : ""; ?>
                    </div>
                    <?php if ($dtCIAcl->checkAccess('DocumentFolder|manage')) { ?>
                        <button type="button" class="btn btn-xs btn-primary" onclick="addDocumentFolderItem()">
                            <i class="ti ti-plus me-1"></i>
                            <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                        </button>
                    <?php } ?>

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('DocumentFolder'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	function documentFolderItem() {

			addValidation("input", ".dt-document-folder-title", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('DocumentFolder.document_folder_title');?>",
                }
            });
			addValidation("textarea", ".dt-description", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('DocumentFolder.description');?>",
                }
            });
            addValidation("input", ".dt-effective-date", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('DocumentFolder.effective_date');?>",
                }
            });
			<?php if($documentFolderId == '') {?> 
				addValidation("input", ".dt-item-image", {
					required: true,
					messages: {
						required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('DocumentFolder.image');?>",
					}
				});
			<?php }?>
        }
    function effectiveDate() {
            $('.dt-effective-date').flatpickr({
                dateFormat: 'd-m-Y',
            });
        }
    $(document).ready(function() {
    	numberInit();
        addSerialNumber('document_folder_item_table');
        effectiveDate();
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_document_folder").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				folder_name: {
					required: true
				},
            },
            messages: {
				folder_name: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('DocumentFolder.folder_name');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("DocumentFolder/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {
						// dtButtonShow('#submitBtn');
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('DocumentFolder');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('DocumentFolder');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
		documentFolderItem();
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
