<!-- Content area -->
<div class="content">

  <?php
  if (isset($message) && $message != '') { ?>
    <div class="alert alert-success alert-dismissible fade show">
      <span class="fw-semibold"><?php echo $message; ?></span>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php } ?>

  <?php 
  $isDailyReportData = isset($isDailyReportAdded) ? $isDailyReportAdded : array();
  $isSuperAdmin = isset($is_super_admin) ? $is_super_admin : array();
  $showDailyReportWarning = empty($isDailyReportData) ? 1 : 0;
  if ($showDailyReportWarning == 1) {
    $class = 'danger';
    $icon = 'ti-alert-triangle';
    $statusMsg = 'Pending';
    $id = "";
    $url = admin_url("DailyReport/manage");
    $exportUrl = admin_url("DailyReport/pdf");
    $addEditBtnTitle = lang('DailyReport.add_daily_report');
  } else {
    $class = 'success';
    $icon = 'ti-browser-check';
    $statusMsg = 'Done';
    $id = $isDailyReportData['id'];
    $url = admin_url("DailyReport/manage/$id");
    $exportUrl = admin_url("DailyReport/pdf/$id");
    $addEditBtnTitle = lang('DailyReport.edit_daily_report');
  }
  ?>

<?php if(!$isSuperAdmin){?>
  <div class="row">

    <div class="col-sm-6 col-lg-3 mb-4">
      <div class="card card-border-shadow-<?= $class; ?>">
        <div class="card-body text-center">
          <!-- Top Section: Icon in middle -->
          <div class="d-flex justify-content-center mb-3">
            <div class="avatar avatar-md">
              <span class="avatar-initial rounded bg-label-<?= $class; ?>">
                <i class="ti <?= $icon; ?> ti-lg ti-md"></i>
              </span>
            </div>
          </div>

          <!-- Middle Section: Status Heading -->
          <h6 class="mb-2"><?= lang('DailyReport.daily_report_status') ?></h6>

          <!-- Status Message as Badge -->
          <div class="mb-3">
            <span class="badge bg-<?= $class; ?>"><?= $statusMsg; ?></span>
          </div>

          <!-- Bottom Section: Two small round buttons -->
          <div class="d-flex justify-content-center gap-2">
            <!-- Export Button -->
            <!-- <button type="button" class="btn btn-sm btn-outline-secondary rounded-pill" title="Export">
                    <i class="ti ti-download"></i>
                </button> -->
                <?php if($showDailyReportWarning != 1){?>
            <a href=<?= $exportUrl ?> data-bs-toggle="tooltip" data-bs-placement="top"
              data-bs-custom-class="custom-tooltip" title=<?= lang('DailyReport.export_daily_report') ?> data-id='<?= $id ?>' class="btn btn-sm btn-icon item-export dt-export-record"><i class="ti ti-download"></i></a>
                  <?php }?>
            <!-- Add/Edit Button -->
            <!-- <button type="button" class="btn btn-sm btn-<?= $class; ?> rounded-pill" title="Add/Edit">
                    <i class="ti ti-edit"></i>
                </button> -->
            <a href=<?= $url ?> data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip"
              title=<?= $addEditBtnTitle ?> data-id='<?= $id ?>'
              class="btn btn-sm btn-icon item-edit dt-edit-record"><i class="ti ti-edit"></i></a>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php }?>
</div>
<!-- /content area -->
